package com.yeejoin.equipmanage.common.entity.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class WlSpareEquipmentExportVo {
    @Excel(name = "装备名称")
    @ExcelProperty(value = "装备名称", index = 0)
    private String name; // 装备名称

    @Excel(name = "装备编码（从装备定义中获取）")
    @ExcelProperty(value = "装备编码（从装备定义中获取）", index = 1)
    private String equipModelCode;

    @Excel(name = "管理方式（单项管理/批量管理）")
    @ExcelProperty(value = "管理方式（单项管理/批量管理）", index = 2)
    private String single;

    @Excel(name = "数量")
    @ExcelProperty(value = "数量", index = 3)
    private Float stockNum; // 库存数量

    @Excel(name = "计量单位")
    @ExcelProperty(value = "计量单位", index = 4)
    private String unit; // 计量单位

    @Excel(name = "规格型号")
    @ExcelProperty(value = "规格型号", index = 5)
    private String standard; // 规格型号

    @Excel(name = "品牌")
    @ExcelProperty(value = "品牌", index = 6)
    private String brand; // 品牌

    @Excel(name = "生产厂家名称")
    @ExcelProperty(value = "生产厂家名称", index = 7)
    private String manufacturer; // 生产厂家

    @Excel(name = "存放位置（建筑或房间编码）")
    @ExcelProperty(value = "存放位置（建筑或房间编码）", index = 8)
    private String warehouseStructure; // 存储位置

    @Excel(name = "位置信息")
    @ExcelProperty(value = "位置信息", index = 9)
    private String position; // 存储位置详情描述

    @Excel(name = "生产日期")
    @ExcelProperty(value = "生产日期", index = 10)
    private String productionDate; // 生产日期

    @Excel(name = "采购日期")
    @ExcelProperty(value = "采购日期", index = 11)
    private String purchaseDate; // 采购日期

    @Excel(name = "备注")
    @ExcelProperty(value = "备注", index = 12)
    private String remark; // 备注

}
