package com.yeejoin.precontrol.common.enums;

/**
 * 消息类型
 *
 * @author Admin
 */
public enum MessageSubTypeEnum {

    RED_COLOR(1, "红码", "", -1),

    PROJECT(2, "项目7天内2次违章", "", -1),

    COMPANY(3, "7天内分包商违章6次", "", -1),

    MANY_PERSON(4, "一个任务三人以上违章", "", -1),

    BLACK(5, "黑名单", "", -1),

    THREE_LEVEL_EXAM_TODO(6, "三级安全考试待办", "您有待办理的三级安全考试任务，前去处理", -1),

    THREE_LEVEL_EXAM_PASSED(7, "三级安全考试通过", "已通过", 1),

    THREE_LEVEL_EXAM_FAILURE(8, "三级安全考试未通过", "未通过", 2),

    SPECIAL_EXAM_TODO(9, "专项考试待办", "您有待办理的专项考试任务，前去处理", -1),

    SPECIAL_EXAM_PASSED(10, "专项考试通过", "已通过", 1),

    SPECIAL_EXAM_FAILURE(11, "专项考试未通过", "未通过", 2),

    RISK_WORK_TODO(12, "风险作业待办", "您有待办理的风险作业任务，前去处理", -1),

    RISK_WORK_EXPIRE(13, "风险作业到期", "风险作业到期", -1),

    VIOLATION_INSPECTION_NEW(14, "违章检查新建", "您有新的违章检查任务，前去处理", -1),

    VIOLATION_INSPECTION_TODO(15, "违章检查待办", "您有待办理的违章检查任务，前去处理", -1),

    SERVICE_REMINDER_NEW_VIOLATION(16, "新的违章", "您有新的违章记录，点击查看", -1),

    SERVICE_REMINDER_RISK_WORK_OVERDUE(17, "风险作业任务超时", "您有超时的风险作业任务未处理，前去处理", 2),

    SERVICE_REMINDER_VIOLATION_FINISHED(18, "违章检查任务完成", "您发起的违章检查任务已完成，点击查看", 1),

    SERVICE_REMINDER_KNOWLEDGE_PUSH_FINISHED(19, "知识推送任务完成", "您发起的知识推送任务已完成，点击查看", 1),

    SERVICE_REMINDER_TECHNICAL_DISCLOSURE_FINISHED(20, "工程交底任务完成", "您发起的工程交底任务已完成，点击查看", -1),

    SERVICE_REMINDER_RISK_WORK_FINISHED(21, "风险作业任务完成", "您发起的风险作业任务已完成，点击查看", 1),

    AUDIT_MSG(22, "人员审核待办", "您有新的人员审核任务，前去处理", -1),

    KNOWLEDGE_PUSH_MSG(23, "知识推送待办", "您有待办理的知识推送任务，前去处理", -1),

    SALARY_CONFIRM_MSG(24, "薪资确认待办", "您有待办理的薪资确认任务，前去处理", -1),
	
	SERVICE_REMINDER_RISK_WORK_EXAM_KNOWLEDGE_EXPIRE(25, "风险作业考试知识超时", "有未按时完成的风险作业人员，点击查看", -1),

    KNOWLEDGE_SHARE_MSG(26, "知识分享消息", "知识分享消息", -1),
	
	RISK_WORK_TECH_TODO(27, "技术交底待办", "您有待办理的技术交底任务，前去处理", -1),
	
	RISK_WORK_TECH_EXPIRE(28, "技术交底到期", "技术交底到期", -1);

    private int type;

    private String name;

    private String tip;

    // 是否完成、超时（1：已完成、已通过；2：已超时、未通过）
    private int status;

    MessageSubTypeEnum(int type, String name, String tip, int status) {
        this.type = type;
        this.name = name;
        this.tip = tip;
        this.status = status;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(int type) {
        String name = null;
        for (MessageSubTypeEnum enumOne : MessageSubTypeEnum.values()) {
            if (enumOne.getType() == type) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public String getTip() {
        return tip;
    }

    public static String getTipByType(int type) {
        String tip = null;
        for (MessageSubTypeEnum enumOne : MessageSubTypeEnum.values()) {
            if (enumOne.getType() == type) {
                tip = enumOne.getTip();
                break;
            }
        }
        return tip;
    }

    public Integer getStatus() {
        return status;
    }

    public static Integer getStatusByType(int type) {
        Integer status = null;
        for (MessageSubTypeEnum enumOne : MessageSubTypeEnum.values()) {
            if (enumOne.getType() == type) {
                status = enumOne.getStatus();
                break;
            }
        }
        return status;
    }
}
