package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.TaskCompanyPerson;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskPersonFile;
import com.yeejoin.precontrol.common.entity.TaskPersonKnowledgeAttachment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 风险管控任务表Vo
 *
 * @author duanwei
 * @date 2021-11-01
 */
@Data
public class TaskRiskControlTechVo implements Serializable {

	private Long id;

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "任务id")
	/**
	 * 任务id
	 */
	private Long taskId;
	@ApiModelProperty(value = "阶段")
	/**
	 * 阶段
	 */
	private Integer stage;
	@ApiModelProperty(value = "技术负责人id")
	/**
	 * 技术负责人id
	 */
	private Long techPersonId;

	private String techPersonName;
	@ApiModelProperty(value = "是否考试")
	/**
	 * 是否考试
	 */
	private Integer isExam;
	@ApiModelProperty(value = "是否知识")
	/**
	 * 是否知识
	 */
	private Integer isKnowledge;
	@ApiModelProperty(value = "组织机构代码")
	/**
	 * 组织机构代码
	 */
	private String orgCode;
	@ApiModelProperty(value = "任务完成时间")
	/**
	 * 任务完成时间
	 */
	private Date taskEndTime;
	@ApiModelProperty(value = "进入风险区域累计人数")
	/**
	 * 进入风险区域累计人数
	 */
	private Integer personCount;
	@ApiModelProperty(value = "更新时间")
	/**
	 * 更新时间
	 */
	private Date updateTime;
	@ApiModelProperty(value = "风险作业id")
	/**
	 * 风险作业id
	 */
	private Long taskRiskControlId;
	@ApiModelProperty(value = "项目id")
	/**
	 * 项目id
	 */
	private Long projectId;
	
	private String projectName;
	@ApiModelProperty(value = "类型 0 1 2")
	/**
	 * 类型 0 1 2
	 */
	private Integer type;
	@ApiModelProperty(value = "施工方案id")
	/**
	 * 施工方案id
	 */
	private Long constructDocumentId;
	private String constructDocumentName;
	@ApiModelProperty(value = "技术交底书id")
	/**
	 * 技术交底书id
	 */
	private Long techDocumentId;
	@ApiModelProperty(value = "作业名称")
	/**
	 * 作业名称
	 */
	private String name;
	@ApiModelProperty(value = "施工方案交底任务id(type1使用)")
	/**
	 * 施工方案交底任务id(type1使用)
	 */
	private Long constructTaskRiskControlTechId;
	@ApiModelProperty(value = "施工方案交底任务名称(type2使用)")
	/**
	 * 施工方案交底任务名称(type2使用)
	 */
	private String constructTaskRiskControlName;

	private Long createPersonId;

	@ApiModelProperty(value = "项目部技术员")
	private List<TaskPerson> techPersonList;

	@ApiModelProperty(value = "项目部安全员")
	private List<TaskPerson> secPersonList;

	@ApiModelProperty(value = "项目部工程人员")
	private List<TaskPerson> proPersonList;

	@ApiModelProperty(value = "其他人员")
	private List<TaskPerson> otherPersonList;

	@ApiModelProperty(value = "分包商人员")
	private List<TaskCompanyPerson> companyPersonList;

	@ApiModelProperty(value = "考试id")
	private Long examId;

	@ApiModelProperty(value = "考试模板名称")
	private Long examTemplateId;

	@ApiModelProperty(value = "考试模板名称")
	private String examTemplateName;

	@ApiModelProperty(value = "考试人员列表")
	private List<TaskPerson> examPersonList;

	private int level;

	private String levelName;

	private Boolean isStart;

	private Date startTime;
	
	private Date endTime;
	
	private Long taskPersonId;
	
	private Long taskPersonType;
	
	private String taskPersonRoleTypeName;

	private TaskPerson taskperson;
	
	@ImagePrefix
	private List<TaskPersonFile> disclosureList;
	
	private int readStatus;
	
	private Boolean firstRead;
	
    @ApiModelProperty(value = "施工方案交底书id")
    private Long constructDisclosureDocumentId;
    
    private List<TaskPersonKnowledgeAttachment> constructDocumentAttachments;
	
    private List<TaskPersonKnowledgeAttachment> techDocumentAttachments;
    
    private List<TaskPersonKnowledgeAttachment> constructDisclosureDocumentAttachments;
}
