package com.yeejoin.equipmanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.equipmanage.common.entity.*;
import com.yeejoin.equipmanage.common.enums.BillContentEnum;
import com.yeejoin.equipmanage.common.enums.FileTypeEnum;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.QRCodeUtil;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.common.vo.EquipmentDate;
import com.yeejoin.equipmanage.mapper.*;
import com.yeejoin.equipmanage.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.yeejoin.equipmanage.service.impl.MqttReceiveServiceImpl.equipmentSpecificMapper;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class EquipmentDetailServiceImpl extends ServiceImpl<EquipmentDetailMapper, EquipmentDetail>
        implements IEquipmentDetailService {

    @Autowired
    private EquipmentDetailMapper equipmentDetailMapper;

    @Autowired
    private EquipmentMapper equipmentMapper;

    @Autowired
    private EquipmentCategoryMapper equipmentCategoryMapper;

    @Autowired
    private EquPropertyMapper equPropertyMapper;

    @Autowired
    private IEquPropertyService iEquPropertyService;

    @Autowired
    private ManufacturerInfoMapper manufacturerInfoMapper;

    @Autowired
    private IEquipmentCategoryService iEquipmentCategoryService;
    @Lazy
    @Autowired
    private IEquipmentService iEquipmentService;

    @Autowired
    private IUnitService iUnitService;

    @Autowired
    private FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    private IStockDetailService stockDetailService;

    @Autowired
    @Lazy
    private IStockService stockService;

    @Autowired
    @Lazy
    private IEquipmentSpecificSerivce equipmentSpecificService;

    @Autowired
    private IEquipmentIndexService equipmentIndexService;

    @Autowired
    private IEquipmentSpecificAlarmLogService equipmentSpecificAlarmLogService;

    @Lazy
    @Autowired
    private IUploadFileService iUploadFileService;
    @Autowired
    private EquipmentOnCarMapper equipmentOnCarMapper;
    @Autowired
    private IEquipmentSpecificIndexSerivce equipmentSpecificIndexSerivce;
    @Autowired
    JCSRemoteService jcsRemoteService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private IExcelService excelService;

    @Value("${auth-key-fire-equip:fire_equip_info}")
    private String authKey;


    @Autowired
    private ISystemDicService iSystemDicService;

    @Override
    public EquipmentDetail saveOne(EquipmentDetail equipmentDetail) {
        Equipment equipment = equipmentMapper.selectById(equipmentDetail.getEquipmentId());
        equipmentDetail.setCode(equipment.getCode());
        this.save(equipmentDetail);
        saveFile(equipmentDetail);
        return equipmentDetail;
    }

    private List<UploadFile> fillFileList(List<UploadFile> list, Long id, String type) {
        if (list == null) {
            return new ArrayList<>();
        }
        list.forEach(item -> {
            item.setUrl(item.getUrl());
            item.setFileType(type);
            item.setObjectType(BillContentEnum.ZB.getKey());
            item.setObjectId(id);
        });
        return list;
    }

    @Override
    public Page<EquipmentDetail> page(Page<EquipmentDetail> pageBean, EquipmentDetail equipmentDetail) {
        List<EquipmentDetail> list = equipmentDetailMapper.page(pageBean.offset(), pageBean.getSize(), equipmentDetail);
        int count = equipmentDetailMapper.count(equipmentDetail);
        pageBean.setRecords(list);
        pageBean.setTotal(count);
        return pageBean;
    }

    @Override
    public EquipmentDetail getOneById(Long id) {
        QueryWrapper<EquipmentDetail> queryWrapper = new QueryWrapper();
        queryWrapper.eq("id",id);
        EquipmentDetail equipmentDetail = equipmentDetailMapper.selectOne(queryWrapper);
        System.out.println("======打印ID"+id);
        if (equipmentDetail == null) {
            return null;
        }
        Equipment equipment = equipmentMapper.selectById(equipmentDetail.getEquipmentId());
        EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectById(equipment.getCategoryId());
        equipment.setEquipmentCategory(equipmentCategory);
        Unit unit = iUnitService.getById(equipment.getUnitId());
        equipment.setUnit(unit);
        equipmentDetail.setEquipment(equipment);
        List<EquProperty> equPropertyList = equPropertyMapper.queryListByEquipDetailId(equipmentDetail.getId());
        equipmentDetail.setEquPropertyList(equPropertyList);
        ManufacturerInfo manufacturerInfo = manufacturerInfoMapper.selectById(equipmentDetail.getManufacturerId());
        if (manufacturerInfo != null) {
            manufacturerInfo.setImg(manufacturerInfo.getImg());
        }
        equipmentDetail.setManufacturerInfo(manufacturerInfo);
        equipmentDetail.setManufacturerName(Objects.isNull(manufacturerInfo) ? "" : manufacturerInfo.getName());
        equipmentDetail.setImg(getEquipFileList(id, FileTypeEnum.image.toString()));
        equipmentDetail.setVideo(getEquipFileList(id, FileTypeEnum.video.toString()));
        equipmentDetail.setCertification(getEquipFileList(id, FileTypeEnum.certificate.toString()));
        equipmentDetail.setInstruction(getEquipFileList(id, FileTypeEnum.instruction.toString()));
        equipmentDetail.setQuality(getEquipFileList(id, FileTypeEnum.quality.toString()));
        equipmentDetail.setOperation(getEquipFileList(id, FileTypeEnum.operation.toString()));
        if (equipmentDetail.getCountry() != null) {
            equipmentDetail.setCountryName(
                    iSystemDicService.getOne(new QueryWrapper<SystemDic>().eq("id", equipmentDetail.getCountry())).getName());
        }
        return equipmentDetail;
    }

    private List<UploadFile> getEquipFileList(Long id, String type) {
        List<UploadFile> list = iUploadFileService.list(new QueryWrapper<UploadFile>().eq("object_id", id)
                .eq("object_type", BillContentEnum.ZB.getKey()).eq("file_type", type));
        list.forEach(item -> {
            item.setUrl(item.getUrl());
        });
        return list;
    }

    @Override
    public boolean updateOneById(Long equipmentSpecificId, EquipmentDetail equipmentDetail) {
        //TODO 页面装备定义调整可编辑，新增逻辑，装备定义id变化时，删除性能指标表，插入新的性能指标
        //1.更新或者插入设备实例的性能指标
        EquipmentDetail dbEquip = this.getOneById(equipmentDetail.getId());
        if (!dbEquip.getEquipmentId().equals(equipmentDetail.getEquipmentId())) {
            //编辑逻辑
            Equipment equipment = equipmentMapper.selectById(equipmentDetail.getEquipmentId());
            equipmentDetail.setCode(equipment.getCode());
            equipmentDetail.setEquipmentName(equipment.getName());
            equipmentSpecificIndexSerivce.remove(new LambdaQueryWrapper<EquipmentSpecificIndex>().eq(EquipmentSpecificIndex::getEquipmentSpecificId, equipmentSpecificId));
            List<EquProperty> equPropertyList = equipmentDetail.getEquPropertyList();
            List<EquipmentSpecificIndex> equipmentSpecificIndexs = equPropertyList.stream().map(p -> {
                EquipmentSpecificIndex specificIndex = new EquipmentSpecificIndex();
                Bean.copyExistPropertis(p, specificIndex);
                specificIndex.setEquipmentSpecificName(equipmentDetail.getName());
                specificIndex.setEquipmentSpecificId(equipmentSpecificId);
                return specificIndex;
            }).collect(Collectors.toList());
            if (!equipmentSpecificIndexs.isEmpty()) {
                equipmentSpecificIndexSerivce.saveBatch(equipmentSpecificIndexs);
            }
        } else {
            //修改指标值逻辑
            List<EquProperty> equPropertyList = equipmentDetail.getEquPropertyList();
            List<EquipmentSpecificIndex> equipmentSpecificIndexs = equPropertyList.stream().map(p -> {
                EquipmentSpecificIndex specificIndex = new EquipmentSpecificIndex();
                Bean.copyExistPropertis(p, specificIndex);
                specificIndex.setEquipmentSpecificName(equipmentDetail.getName());
                specificIndex.setEquipmentSpecificId(equipmentSpecificId);
                specificIndex.setValue(p.getValue());
                return specificIndex;
            }).collect(Collectors.toList());
            if (!equipmentSpecificIndexs.isEmpty()) {
                equipmentSpecificIndexSerivce.updateIndexValueBatchByUniqueKey(equipmentSpecificId, equipmentSpecificIndexs);
            }
        }
        //2.更新Detail表

        if (StringUtil.isNotEmpty(equipmentDetail.getArea())) {
            String[] addressData = equipmentDetail.getArea().split("@address@");
            if (addressData.length > 1) {
                equipmentDetail.setArea(addressData[0]);
                JSONObject langLatObj = JSON.parseObject(addressData[1]);
                if (StringUtil.isNotEmpty(langLatObj.getString("longitude"))) {
                    equipmentDetail.setLongitude(Double.valueOf(langLatObj.getString("longitude")));
                }
                if (StringUtil.isNotEmpty(langLatObj.getString("latitude"))) {
                    equipmentDetail.setLatitude(Double.valueOf(langLatObj.getString("latitude")));
                }
            }
        }
        equipmentDetailMapper.updateById(equipmentDetail);
        //3.保存图片
        iUploadFileService.remove(new QueryWrapper<UploadFile>().eq("object_type", BillContentEnum.ZB.getKey())
                .eq("object_id", equipmentDetail.getId()));
        saveFile(equipmentDetail);
        return true;
    }

    private void saveFile(EquipmentDetail equipmentDetail) {
        List<UploadFile> fileList = new ArrayList<>();
        fileList.addAll(fillFileList(equipmentDetail.getImg(), equipmentDetail.getId(), FileTypeEnum.image.toString()));
        fileList.addAll(fillFileList(equipmentDetail.getVideo(), equipmentDetail.getId(), FileTypeEnum.video.toString()));
        fileList.addAll(fillFileList(equipmentDetail.getCertification(), equipmentDetail.getId(), FileTypeEnum.certificate.toString()));
        fileList.addAll(fillFileList(equipmentDetail.getInstruction(), equipmentDetail.getId(), FileTypeEnum.instruction.toString()));
        fileList.addAll(fillFileList(equipmentDetail.getQuality(), equipmentDetail.getId(), FileTypeEnum.quality.toString()));
        fileList.addAll(fillFileList(equipmentDetail.getOperation(), equipmentDetail.getId(), FileTypeEnum.operation.toString()));
        iUploadFileService.saveBatch(fileList);
    }

    @Override
    public boolean removeOneById(long id) {
        equipmentDetailMapper.deleteById(id);
        Map<String, Object> columnMap = new HashMap<String, Object>();
        columnMap.put("equipment_detail_id", id);
        iEquPropertyService.removeByMap(columnMap);
        return true;
    }

    @Override
    public Page<EquipmentDetail> page(Page<EquipmentDetail> pageBean, String category) {
        char[] chars = category.toCharArray();
        String newcategory = "";
        for (int i = chars.length - 1; i >= 0; i--) {
            if ("0".equals(String.valueOf(chars[i]))) {
                newcategory = category.substring(0, i);
            } else {
                break;
            }
        }
        List<EquipmentCategory> categoryList = iEquipmentCategoryService
                .list(new QueryWrapper<EquipmentCategory>().likeRight("code", newcategory));
        List<EquipmentDetail> list = equipmentDetailMapper.pageCategory(pageBean.offset(), pageBean.getSize(),
                categoryList);
        list.forEach(item -> {
            Equipment equipment = iEquipmentService.getById(item.getEquipmentId());
            Unit unit = iUnitService.getById(equipment.getUnitId());
            equipment.setUnit(unit);
            item.setEquipment(equipment);
        });
        int count = equipmentDetailMapper.countCategory(pageBean.offset(), pageBean.getSize(), categoryList);
        Page<EquipmentDetail> page = new Page<EquipmentDetail>(pageBean.getCurrent(), pageBean.getSize());
        page.setRecords(list);
        page.setTotal(count);
        return page;
    }

    @Override
    public boolean removeBatchById(List<Long> idList) {
        idList.forEach(x -> {
            QueryWrapper<EquipmentOnCar> wrapper = new QueryWrapper<>();
            wrapper.eq("equipment_detail_id", x);
            if (equipmentOnCarMapper.selectCount(wrapper) > 0) {
                throw new RuntimeException("已装备的设备不能删除");


            }
        });
        return this.removeByIds(idList);
    }

    @Override
    public boolean quotaUpdate(List<EquProperty> e) {
        for (EquProperty a : e) {
            equipmentDetailMapper.quotaUpdate(a);
        }
        return false;
    }

    @Override
    public String getPref(String id) {
        return equipmentDetailMapper.getPref(id);
    }

    @Override
    public String checkDelete(List<Long> ids) {
        String res = "";
        for (Long id : ids) {
            String s = equipmentDetailMapper.checkDelete(id);
            if (s != null && !("").equals(s)) {
                res = res + s + " , ";
            }
        }
        return res;
    }

    @Override
    public List<OrgMenuDto> companyDeptTree() {
        return jcsRemoteService.getCompanyDeptTreeWithAuth(authKey, null);
    }

    /**
     * @param id
     * @return
     */
    @Override
    public Map<String, Object> getEquipScrapDate(long id) {
        return equipmentDetailMapper.selectEquipScrapDate(id);
    }

    /**
     * 获取装备基本信息
     */
    @Override
    public EquipmentDate getEquipmentBasicInformation(Long id, Long stockDetailId) {
        EquipmentDate equipmentDate = new EquipmentDate();
        EquipmentSpecific equipmentSpecific = equipmentSpecificService.getById(id);
        EquipmentSpecific specific = equipmentSpecificService.getEquipSpecificEntityByCode(equipmentSpecific.getCode());
        equipmentSpecific.setEquipCondition(specific.getEquipCondition());
        equipmentSpecific.setFullqrCode("01#" + equipmentSpecific.getQrCode());
        System.out.println("==============ID"+equipmentSpecific.getEquipmentDetailId());
        EquipmentDetail equipmentDetail = this.getOneById(equipmentSpecific.getEquipmentDetailId());
        StockDetail stockDetail = null;
        if (stockDetailId != null) {
            //解决灭火药剂，有多个货位状态问题
            stockDetail = stockDetailService.getById(stockDetailId);
            equipmentSpecific.setStockDetail(stockDetail);
        } else {
            //消防装备默认分支
            List<StockDetail> stockDetails = stockDetailService.list(new LambdaQueryWrapper<StockDetail>().eq(StockDetail::getEquipmentSpecificId, id));
            if (!stockDetails.isEmpty()) {
                stockDetail = stockDetails.get(0);
                equipmentSpecific.setStockDetail(stockDetail);
            }
        }
        if (stockDetail != null) {
            equipmentSpecific.setStock(stockService.getById(stockDetail.getStockId()));
        }
        // 到期应报废日期
        Map<String, Object> scrapInfo = this.getEquipScrapDate(id);
        if (Objects.nonNull(scrapInfo)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String planScrapDate = scrapInfo.getOrDefault("planScrapDate", "").toString();
            if (Objects.nonNull(planScrapDate)) {
                try {
                    equipmentDetail.setScrapDate(dateFormat.parse(planScrapDate));
                } catch (ParseException e) {
                    log.error("时间格式异常：", e);
                }
            }
            // 剩余服役天数 = 报废日期 - 当前日期
            Date scrapDate = equipmentDetail.getScrapDate();
            if (Objects.nonNull(scrapDate)) {
                Date nowDate = DateUtils.getDateNow();
                try {
                    int i = DateUtils.dateBetween(scrapDate, nowDate);
                    equipmentDetail.setRemainingDays(Integer.parseInt(String.valueOf(i).replace("-", "")));
                } catch (ParseException e) {
                    log.error("时间计算异常：", e);
                }
            }
        }
        // 实时信号
        List<EquipmentSpecificAlarmLog> alarmLogs = equipmentSpecificAlarmLogService.list(
                Wrappers.<EquipmentSpecificAlarmLog>lambdaQuery()
                        .select(EquipmentSpecificAlarmLog::getEquipmentSpecificIndexName)
                        .eq(EquipmentSpecificAlarmLog::getEquipmentSpecificId, id)
                        .isNull(EquipmentSpecificAlarmLog::getCleanTime)
                        .orderByDesc(EquipmentSpecificAlarmLog::getCreateDate)
        );
        equipmentDetail.setSignal("-");
        if (!alarmLogs.isEmpty()) {
            String signal = alarmLogs.get(0).getEquipmentSpecificIndexName();
            equipmentDetail.setSignal(Objects.nonNull(signal) ? signal : "-");
        }
        // 二维码
        String equipStatus = equipmentSpecific.getEquipStatus();
        int type = Objects.equals(equipStatus, "0") ? 3 : Objects.equals(equipStatus, "1") ? 2 : 1;
        String qrCodeImage = QRCodeUtil.genQrCodeBase64PngWithWord(equipmentSpecific.getQrCode(), 200, 200, equipmentSpecific.getQrCode(),200, type);
        equipmentDetail.setQrCodeImage(qrCodeImage);
        // 消防系统
        if (StringUtil.isNotEmpty(equipmentSpecific.getSystemId())) {
            List<FireFightingSystemEntity> sys = fireFightingSystemMapper.getFightingSysByIds(equipmentSpecific.getSystemId().split(","));
            StringBuilder sb = new StringBuilder();
            for (FireFightingSystemEntity entity : sys) {
                sb.append(entity.getName()).append(",");
            }
            equipmentSpecific.setSystemName(sb.toString());
        }
        // 装备分类
        Equipment equipment = equipmentDetail.getEquipment();
        if (Objects.nonNull(equipment)) {
            EquipmentCategory equipmentCategory = equipment.getEquipmentCategory();
            equipmentDetail.setCategoryName(equipmentCategory.getName());
        }
        // 装备单位
        if(!ObjectUtils.isEmpty(equipmentSpecific.getRealtimeIotIndexId())){
            EquipmentIndex equipmentIndex = equipmentIndexService.getById(equipmentSpecific.getRealtimeIotIndexId());
            if (!ObjectUtils.isEmpty(equipmentIndex)) {
                equipmentSpecific.setIsTrend(equipmentIndex.getIsTrend());
                equipmentSpecific.setUnit(equipmentIndex.getUnit());
            }
        }
        // 查询指标参数
        Wrapper<EquipmentSpecificIndex> equipmentSpecificIndexWrapper = Wrappers.<EquipmentSpecificIndex>lambdaQuery().eq(EquipmentSpecificIndex::getEquipmentSpecificId, id);
        List<EquipmentSpecificIndex> equipIndexList = equipmentSpecificIndexSerivce.list(equipmentSpecificIndexWrapper);
        List<Map<String, Object>> indexMaps = new ArrayList<>();
        if (!CollectionUtils.isEmpty(equipIndexList)) {
            equipIndexList.forEach(v -> {
                Map<String, Object> indexMap = new LinkedHashMap<>();
                indexMap.put("equipmentIndexName", v.getEquipmentIndexName());
                indexMap.put("indexValue", handleIndexValue(v.getValue()));
                indexMaps.add(indexMap);
            });
        }
        equipmentSpecific.setIndexParameter(indexMaps);

        List<EquProperty> equPropertyList = equPropertyMapper.queryListByEquipDetailId(equipmentDetail.getId());
        equipmentDetail.setEquPropertyList(equPropertyList);
        ManufacturerInfo manufacturerInfo = manufacturerInfoMapper.selectById(equipmentDetail.getManufacturerId());
        if (manufacturerInfo != null) {
            manufacturerInfo.setImg(manufacturerInfo.getImg());
        }
        equipmentDetail.setManufacturerInfo(manufacturerInfo);
        equipmentDetail.setManufacturerName(Objects.isNull(manufacturerInfo) ? "" : manufacturerInfo.getName());
        equipmentDetail.setImg(getEquipFileList(equipmentDetail.getId(), FileTypeEnum.image.toString()));
        equipmentDetail.setVideo(getEquipFileList(equipmentDetail.getId(), FileTypeEnum.video.toString()));
        equipmentDetail.setCertification(getEquipFileList(equipmentDetail.getId(), FileTypeEnum.certificate.toString()));
        equipmentDetail.setInstruction(getEquipFileList(equipmentDetail.getId(), FileTypeEnum.instruction.toString()));
        equipmentDetail.setQuality(getEquipFileList(equipmentDetail.getId(), FileTypeEnum.quality.toString()));
        equipmentDetail.setOperation(getEquipFileList(equipmentDetail.getId(), FileTypeEnum.operation.toString()));
        if (equipmentDetail.getCountry() != null) {
            equipmentDetail.setCountryName(
                    iSystemDicService.getOne(new QueryWrapper<SystemDic>().eq("id", equipmentDetail.getCountry())).getName());
        }

        equipmentDate.setEquipmentDetail(equipmentDetail);
        equipmentDate.setEquipmentSpecific(equipmentSpecific);
        return equipmentDate;
    }

    private String handleIndexValue(Object indexValue) {
        if (!ObjectUtils.isEmpty(indexValue)) {
            String val = String.valueOf(indexValue).toUpperCase();
            switch (val) {
                case "TRUE":
                    return "是";
                case "FALSE":
                    return "否";
                default:
                    return val;
            }
        }
        return "";
    }
}
