package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "变化的数据")
public class FieldChangeMeta implements Serializable {

    /**
     * 必须字段-字段key
     */
    private String columnKey;

    /**
     * 必须字段-字段描述
     */
    private String columnLabel;

    /**
     * 必须字段-字段原始值
     */
    private String columnOldValue;

    /**
     * 必须字段-字段新值
     */
    private String columnNewValue;

    /**
     * 非必须字段-变化的数据id(设备的record、或者业务的id),持使用登记的设备信息变更、不同业务流程的业务数据变更
     */
    private String changeId;

    /**
     * 非必须字段-变更数据的分类：如使用信息、制造信息、设计信息、技术参数 - key
     */
    private String columnFamily;

    /**
     * 非必须字段-字段类型-扩展使用
     */
    private String columnType;


    /**
     * 显示的新值
     */
    private String displayNewValue;

    /**
     * 显示的旧值
     */
    private String displayOldValue;

    /**
     * 元数据
     */
    private FieldDisplayDefine fieldDisplayDefine;

    /**
     * 是否冗余字段（如行政区划对应的名称字段，在记录日志时不会冗余记录次）
     */
    private Boolean isRepeatColumn;

}
