package com.yeejoin.amos.boot.module.ymt.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ymt.api.dto.RepairConsultDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.RepairConsult;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.RepairConsultServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 警情填报业务数据项
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "处置过程Api")
@RequestMapping(value = "/repair-consult")
public class RepairConsultController extends BaseController {

    @Autowired
    RepairConsultServiceImpl repairConsultServiceImpl;

    /**
     * 新增警情填报业务数据项
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增警情填报业务数据项", notes = "新增警情填报业务数据项")
	public ResponseModel<RepairConsultDto> save(@RequestBody RepairConsultDto model) {
	    model = repairConsultServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据警情id 查找处置过程日志
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据警情id 查找处置过程日志",   notes = "根据警情id 查找处置过程日志")
	@GetMapping(value = "/list/alert/{alertId}")
	public ResponseModel<List<RepairConsult>> selectForListByAlertId(@PathVariable Long alertId) {
		LambdaQueryWrapper<RepairConsult> queryWrapper = new LambdaQueryWrapper<RepairConsult>();
		queryWrapper.eq(RepairConsult::getParentId, alertId).orderByDesc(RepairConsult::getRecDate);
		List<RepairConsult> list = repairConsultServiceImpl.list(queryWrapper);
		return ResponseHelper.buildResponse(list);
	}
}
