package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.ugp.api.entity.Inspection;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.InspectionServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
 * @author duanwei
 * @date 2022-11-03
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/tz-ugp-inspection")
public class InspectionController {


    @Autowired
    InspectionServiceImpl iTzUgpInspectionServiceImpl;


    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveTzUgpInspection(HttpServletRequest request, @RequestBody Inspection tzUgpInspection) {
        return iTzUgpInspectionServiceImpl.save(tzUgpInspection);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iTzUgpInspectionServiceImpl.removeById(id);
    }


    /**
     * 修改
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdTzUgpInspection(HttpServletRequest request, @RequestBody Inspection tzUgpInspection) {
        return iTzUgpInspectionServiceImpl.updateById(tzUgpInspection);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public Inspection selectById(HttpServletRequest request, @PathVariable Long id) {
        return iTzUgpInspectionServiceImpl.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<Inspection> listPage(String pageNum, String pageSize,
                                      Inspection tzUgpInspection) {

        Page<Inspection> pageBean;
        QueryWrapper<Inspection> tzUgpInspectionQueryWrapper = new QueryWrapper<>();
        Class<? extends Inspection> aClass = tzUgpInspection.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(tzUgpInspection);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(tzUgpInspection);
                        tzUgpInspectionQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(tzUgpInspection);
                        tzUgpInspectionQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(tzUgpInspection);
                        tzUgpInspectionQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(tzUgpInspection);
                        tzUgpInspectionQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<Inspection> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iTzUgpInspectionServiceImpl.page(pageBean, tzUgpInspectionQueryWrapper);
        return page;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "", notes = "")
    @GetMapping("/saveInfo")
    public ResponseModel<String> saveInfo(@RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(iTzUgpInspectionServiceImpl.saveInfo(jsonObject));
    }
}


