package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.ugp.api.entity.SuperviseRule;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.*;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.SuperviseRuleServiceImpl;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.SuperviseRuleDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 监管区域规则表
 *
 * @author system_generator
 * @date 2022-10-18
 */
@RestController
@Api(tags = "监管区域规则表Api")
@RequestMapping(value = "/supervise-rule")
public class SuperviseRuleController extends BaseController {

    @Autowired
    SuperviseRuleServiceImpl superviseRuleServiceImpl;
	//private int current;
	@Autowired
	OrgServiceImpl orgServiceImpl;

	/**
     * 新增监管区域规则表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增监管区域规则表", notes = "新增监管区域规则表")
	public ResponseModel<SuperviseRuleDto> save(@RequestBody SuperviseRuleDto model) {
    	model.setCreateDate(new Date());
    	//外网调不到内网，所以报错,暂时预留
    	Collection<RegionModel> result = Systemctl.regionClient.queryForTree(null).getResult();
		//result是一个树结构的集合，需要递归
		Map<String,String> map = new HashMap<>();
		getMap(map,result);
		//获取的Map中key是code，value是name
		model.setAdminRegion(map.get(model.getAdminRegionCode()));
    	//外网调不到内网 暂时预留
		OrgUsr orgUsr = orgServiceImpl.getOrgUsr();
		model.setCreateUnitId(orgUsr.getSequenceNbr());
		try{
			model = superviseRuleServiceImpl.createWithModel(model);
		}catch (Exception e) {
		    return CommonResponseUtil.failure("该区域已经有规则了，请勿重复添加");
		}

	    return ResponseHelper.buildResponse(model);
	}

	public void getMap(Map map,Collection<RegionModel> collection){
    	Iterator<RegionModel> iterator = collection.iterator();
    	while(iterator.hasNext()){
			RegionModel regionModel = iterator.next();
			map.put(regionModel.getRegionCode(),regionModel.getRegionName());
			if(!ValidationUtil.isEmpty(regionModel.getChildren())){
				getMap(map,regionModel.getChildren());
			}
		}
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@PutMapping(value = "")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新监管区域规则表", notes = "根据sequenceNbr更新监管区域规则表")
	public ResponseModel<SuperviseRuleDto> updateBySequenceNbrSuperviseRule(@RequestBody SuperviseRuleDto model,@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
		model.setRecDate(new Date());
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除监管区域规则表", notes = "根据sequenceNbr删除监管区域规则表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @RequestParam(value = "sequenceNbr") String sequenceNbr){
		List<Long> ids = Arrays.stream(sequenceNbr.split(",")).map(Long::valueOf).collect(Collectors.toList());
		try{
			return ResponseHelper.buildResponse(superviseRuleServiceImpl.removeByIds(ids));
		} catch (Exception e){
			return ResponseHelper.buildResponse(false);
		}
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个监管区域规则表",  notes = "根据sequenceNbr查询单个监管区域规则表")
	public ResponseModel<SuperviseRuleDto> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "监管区域规则表分页查询",  notes = "监管区域规则表分页查询")
	public ResponseModel<IPage<SuperviseRuleDto>> queryForPage(
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			SuperviseRule superviseRule
	) {
		//this.current = current;
		Page page = new Page<>();
	    page.setCurrent(current);
	    page.setSize(size);

	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryForSuperviseRulePage(page,superviseRule));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "监管区域规则表列表全部数据查询",   notes = "监管区域规则表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<SuperviseRuleDto>> selectForList() {
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryForSuperviseRuleList());
	}

	/**
	 * 根据sequenceNbr查询标准规则库
	 *
	 * @param sequenceNbr  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/queryBySeq/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询监管区域规则表",  notes = "根据sequenceNbr查询监管区域规则表")
	public ResponseModel<SuperviseRuleDto> queryBySeq(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryBySeq(sequenceNbr));
	}

}
