package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.dto.UserDto;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WelderDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WelderEquipmentDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectResourceMapper;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectResourceServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.WelderServiceImpl;
import com.yeejoin.amos.feign.privilege.Privilege;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@Api(tags = "焊工信息")
@RequestMapping(value = "/welder")
public class WelderController extends BaseController {
    @Autowired
    OrgServiceImpl orgService;
    @Autowired
    ProjectMapper projectMapper;

    @Autowired
    ProjectServiceImpl projectService;

    @Autowired
    WelderServiceImpl welderServiceImpl;

    @Autowired
    OrgServiceImpl orgServiceImpl;

    @Autowired
    ProjectResourceMapper projectResourceMapper;

    @Autowired
    ProjectResourceServiceImpl  projectResourceServiceImpl;
    /**
     * 新增/修改焊工信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @RequestMapping(value = "/saveWelder", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增人员信息", notes = "新增人员信息")
    public ResponseModel<OrgUsrDto> saveWelder(@RequestBody JSONObject jsonObject, @RequestParam String bizOrgType ,
                                            @RequestParam(required = false) String sequenceNbr) {
        return ResponseHelper.buildResponse(welderServiceImpl.savePerson(jsonObject,bizOrgType,sequenceNbr));
    }

    /**
     * 获取焊工信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectWelder")
    @ApiOperation(httpMethod = "GET", value = "获取焊工信息", notes = "获取焊工信息")
    public ResponseModel<List<JSONObject>> selectWelder() {
        List<JSONObject> jsonObjectList=new ArrayList<>();
//        LambdaQueryWrapper<Project> wrapper=new LambdaQueryWrapper<>();
//        wrapper.eq(Project::getCode,code);
//        Project project = projectMapper.selectOne(wrapper);
        //根据登录人获取登录人单位下焊工
        List<Map> info = orgService.getCompanyWelder(null).getRecords();
        for (Map<String,Object> map:info){
            JSONObject jsonObject=new JSONObject();
            jsonObject.put("name",map.get("name"));
            jsonObject.put("sequenceNbr",map.get("sequenceNbr"));
            jsonObjectList.add(jsonObject);
        }

        return ResponseHelper.buildResponse(jsonObjectList);
    }
    /**
     * 项目焊工人员分页查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "项目焊工人员分页查询列表", notes = "项目焊工人员分页查询列表")
    @GetMapping(value = "/getpageInfo")
    public ResponseModel<IPage<Map>> getpageInfo(){
        return ResponseHelper.buildResponse(welderServiceImpl.getpageInfo());
    }

    /**
     * 项目焊工人员删除
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/delWelder/{sequenceNbr}")
    @ApiOperation(httpMethod = "Delete", value = "项目焊工人员删除", notes = "项目焊工人员删除")
    public ResponseModel<Boolean> deleteByResourceId(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(projectResourceMapper.deleteByResourceId(sequenceNbr));
    }

    /**
     * 当前登陆人所在公司/单位/企业 下的 所有焊工人员分页查询
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "当前登陆人所在公司/单位/企业下的所有焊工人员分页列表", notes = "当前登陆人所在公司/单位/企业下的所有焊工人员分页查询列表")
    @GetMapping(value = "/getCompanyWelder")
    public ResponseModel<IPage> getCompanyWelder(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(required = false) String name,
            @RequestParam(required = false) String idNumber,
            @RequestParam(required = false) String licensedProject
    ){
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        IPage companyWelder = orgServiceImpl.getCompanyWelder(page);

        List<Map> welderRecords = companyWelder.getRecords();

        //模糊查询
        if (name!=null||idNumber!=null||licensedProject!=null){
            if (name!=null) {welderRecords = welderRecords.stream().filter(n -> ((String)n.get("name")).indexOf(name)>-1).collect(Collectors.toList());}
            if (idNumber!=null) {welderRecords = welderRecords.stream().filter(n -> ((String)n.get("idNumber")).indexOf(idNumber)>-1).collect(Collectors.toList());}
            if (licensedProject!=null) {welderRecords = welderRecords.stream().filter(n -> ((String)n.get("licensedProject")).indexOf(licensedProject)>-1).collect(Collectors.toList());}
        }

        Page records = page.setRecords(welderRecords);
        return ResponseHelper.buildResponse(records);
    }

    /**
     * 根据sequenceNbr查询人员信息
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询人员信息", notes = "根据sequenceNbr查询人员信息")
    public ResponseModel<Map> selectOneById(@PathVariable String sequenceNbr) {
        return ResponseHelper.buildResponse(orgServiceImpl.getdetialInfo(sequenceNbr));
    }

    /**
     * 根据sequenceNbr删除人员信息表
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/deleteOneById/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr删除人员信息表", notes = "根据sequenceNbr删除人员信息表")
    public ResponseModel<String> deleteOneById(@PathVariable String sequenceNbr) throws Exception {
//        Privilege.agencyUserClient.multDeleteUser(orgServiceImpl.getOrgUsrById(sequenceNbr).getAmosOrgId());
        orgServiceImpl.delectInfo(sequenceNbr);
        return ResponseHelper.buildResponse("ok");
    }

    /**
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "", notes = "")
    @GetMapping(value = "/getUserInfo")
    @BusinessIdentify
    public ResponseModel<IPage> getUserInfo(int current, int size){
        IPage page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        page = orgServiceImpl.getPersonInfo(String.valueOf(orgServiceImpl.getReginParams().getCompany().getSequenceNbr()),page);
        List<Map> mapList = page.getRecords();
        for(Map map : mapList){
            if(OrgEnum.焊工.getKey().equals((String)map.get("type"))){
                map.put("typeName",OrgEnum.焊工.getName());
            }else{
                map.put("typeName",OrgEnum.普通人员.getName());
            }
        }
        return ResponseHelper.buildResponse(page);
    }

}
