package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;

import com.alibaba.fastjson.JSONObject;

import com.alibaba.fastjson.serializer.SerializerFeature;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.mao.expertSystem.WeldingQualification;
import com.mao.expertSystem.material.MyPqr;
import com.mao.expertSystem.material.MyWps;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;

import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;

import com.yeejoin.amos.boot.module.ugp.api.Enum.VerifyEnum;

import com.yeejoin.amos.boot.module.ugp.api.Enum.VerifyTypeEnum;

import com.yeejoin.amos.boot.module.ugp.api.dto.*;

import com.yeejoin.amos.boot.module.ugp.api.entity.QualityProblem;

import com.yeejoin.amos.boot.module.ugp.api.entity.Verify;

import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;

import com.yeejoin.amos.boot.module.ugp.api.mapper.VerifyMapper;

import com.yeejoin.amos.boot.module.ugp.api.mapper.WeldMapper;

import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;

import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import org.apache.commons.lang.StringUtils;

import org.springframework.beans.factory.annotation.Autowired;

import org.typroject.tyboot.core.rdbms.service.BaseService;

import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.*;

import java.util.stream.Collectors;



/**

 * 智能监检管理表服务实现类

 *

 * @author system_generator

 * @date 2022-09-22

 */

@Service

public class VerifyServiceImpl extends BaseService<VerifyDto,Verify,VerifyMapper> implements IVerifyService {

    @Autowired

    InstallNoticeServiceImpl installNoticeService;

    @Autowired

    WeldServiceImpl weldService;

    @Autowired

    WeldMapper weldMapper;

    @Autowired

    OrgServiceImpl orgService;


   @Autowired
   private  MaterialServiceImpl materialService;
    @Autowired

    VerifyMapper verifyMapper;
     @Autowired
     private EquipmentServiceImpl equipmentService;
    @Autowired

    QualityProblemServiceImpl qualityProblemService;

    /**

     * 分页查询

     */

    public Page<VerifyDto> queryForVerifyPage(Page<VerifyDto> page)   {

        return this.queryForPage(page, null, false);

    }

    /**
     * 列表查询 示例

     */

    public List<VerifyDto> queryForVerifyList()   {
        return this.queryForList("" , false);

    }
    /**  cpp

     * 智能监检共用查询方法

     * stage 阶段

     * page 分页

     */
    private static final String HEGE ="合格期内";
    private static final String NOTHEGE ="超期未检";
    public Page<SmartListDto> commonality(String stage,Page<SmartListDto> page,SmartListDto smartListDto){
        List<Verify> verifyList = verifyMapper.commonality(stage,smartListDto);
        List<SmartListDto> dtoList =new ArrayList<>();
        //进入焊前
        if (verifyList !=null && verifyList.size() !=0){

            for (Verify verify : verifyList) {


                SmartListDto dto = new SmartListDto( );
                dto.setSequenceNbr(verify.getSequenceNbr());//智能监检表id
                dto.setProjectId(verify.getProjectId());  //项目id
                dto.setName(verify.getProject().getName());//项目名称
                dto.setProjectCode(verify.getProject().getCode());//项目编号
                //检验状态
                String status = verify.getStatus( );
                if (status.equals(VerifyEnum.已通过.getStatus())) {
                    dto.setStatus(VerifyEnum.已通过.getName());
                }
                if (status.equals(VerifyEnum.未通过.getStatus())) {
                    dto.setStatus(VerifyEnum.未通过.getName());
                }
                dto.setType(verify.getType());//检验方式
                dto.setSubmitTime(verify.getSubmitTime());//交检日期
                dto.setVerifyTime(verify.getVerifyTime());//检验时间
                String stage1 = verify.getStage( );//检验检测阶段

                Map<String, String> map = StageEnum.getStatusByVerifyNameMap;
                for (String key:map.keySet()){
                    if (key.equals(stage1)) {
                        dto.setStage(map.get(key).toString());//将阶段赋值
                    }
                }
                String targetInfo = verify.getTargetInfo();//app上传数据
                Map mapInfo = JSON.parseObject(targetInfo, Map.class);
                for (Object o:mapInfo.keySet()){
                    if (o.toString().equals("code")) {
                        //获取焊口编号
                        String code = (String)mapInfo.get(o.toString( ));
                        dto.setCode(code);
                    }

                    if (o.toString().equals("peopleLocation")) {
                        //获取焊接定位信息
                        String peopleLocation = (String)mapInfo.get(o.toString( ));
                        dto.setPeopleLocation(peopleLocation);
                    }


                    //人员
                        if (o.toString().equals("userId")) {
                            //获取焊工信息
                            String userId = mapInfo.get(o.toString( )).toString();
                            if (userId != null) {
                                OrgUsr orgUsr = orgService.getOrgUsrById(userId);
                                dto.setPeopleName(orgUsr.getBizOrgName());//焊工姓名
                                dto.setPersonWeld(orgUsr.getCode());//焊工编号
                            }
                        }

                        //持证判断


                     //设备

                        if (o.toString().equals("facilityId")) {
                            //设备id
                            Long eId = Long.valueOf(mapInfo.get(o.toString( )).toString());
                            if (eId != null) {
                                //获取设备
                                EquipmentDto equipmentDto = equipmentService.queryBySeq(eId);

                                if (equipmentDto != null) {
                                    //设备名  设备编号
                                    dto.setFacilityName(equipmentDto.getName());
                                    dto.setFacilityNumber(equipmentDto.getCode());
                                }

                            }
                        }

                    //管材

                        if (o.toString().equals("materialId")) {
                            //管材id
                            Long mId =  Long.valueOf(mapInfo.get(o.toString( )).toString());
                            if (mId != null) {
                                MaterialDto materialDto = materialService.queryBySeq(mId);

                                if (materialDto != null) {
                                    //管材厂家 生产编号
                                    dto.setManufacturer(materialDto.getManufacturer());
                                    dto.setBatchNumber(materialDto.getBatchNum());
                                    //生产日期需要判断(加判断)是否在有效期内
                                    Date manufactureDate = materialDto.getManufactureDate( );

                                    //将判断结果
                                    dto.setPermission(HEGE);
                                }

                            }
                        }

                    //工艺
                    if (o.toString().equals("craft")) {
                        //获取焊接工艺
                        String craft = mapInfo.get(o.toString( )).toString();
                        if (!StringUtils.isEmpty(craft)) {
                            dto.setCraft(craft);
                        }
                    }
                    if (o.toString().equals("weldingId")) {

                        //设备id
                        Long eId = Long.valueOf(mapInfo.get(o.toString( )).toString());
                        if (eId != null) {
                            //获取设备
                            EquipmentDto equipmentDto = equipmentService.queryBySeq(eId);

                            if (!StringUtils.isEmpty(equipmentDto.getCode())) {
                                // 焊机编号
                                dto.setFacilityNumber(equipmentDto.getCode());
                            }

                        }
                    }

                    //耐压
                    if (o.toString().equals("pressureId")) {
                        Long pressureId = Long.valueOf(mapInfo.get(o.toString( )).toString());
                        if (pressureId !=null) {
                            EquipmentDto equipmentDto = equipmentService.queryBySeq(pressureId);
                            if (equipmentDto != null && !StringUtils.isEmpty(equipmentDto.getName()) &&!StringUtils.isEmpty(equipmentDto.getCode())) {
                                    dto.setPressureName(equipmentDto.getName());
                                    dto.setPressureCode(equipmentDto.getCode());
                            }
                        }
                    }
                    if (o.toString().equals("pressureTest")) {
                        String mpa = mapInfo.get(o.toString( )).toString();
                        if (!StringUtils.isEmpty(mpa)) {
                            dto.setMpa(mpa);
                        }
                    }

                    //埋深 埋深检测方式

                    if (o.toString().equals("depthType")) {
                        String depthType = mapInfo.get(o.toString( )).toString();
                        if (!StringUtils.isEmpty(depthType)) {
                            dto.setDetectionMethod(depthType);
                        }
                    }

                    if (o.toString().equals("depth")) {
                        String depth = mapInfo.get(o.toString( )).toString();
                        if (!StringUtils.isEmpty(depth)) {
                            dto.setBurialDepth(depth);
                        }
                    }
                    //位置标定
                    if (o.toString().equals("locationType")) {
                        String locationType = mapInfo.get(o.toString( )).toString();
                        if (!StringUtils.isEmpty(locationType)) {
                            dto.setPreciseWeldingPosition(locationType);
                        }
                    }
                     //判断标定检验结果   getResuts
                }
                dtoList.add(dto);

            }
        }
        page.setRecords(dtoList);
        page.setTotal(dtoList.size());

        return page ;
    }



    /**  cpp
     * 智能监检校验数据
     * @param jsonObject
     * @return String
     */
    private static final String TYPE="智能检验";

    @BusinessIdentify
    public String checks(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.size() ==0) {
            return  VerifyEnum.未通过.getName();
        }
        //通过userid和projectId来对应
        Long welderId = orgService.getReginParams( ).getBusinessInfo( ).getUserSequenceNbr( );
        Long random = jsonObject.getLong("random");//随机值
        Long projectId= jsonObject.getLong("projectId");//项目id
        //假数据Long welderId = jsonObject.getLong("welderId"); //焊工id
        String location = jsonObject.getString("location");//焊接定位信息
        String stage = jsonObject.getString("stage");//阶段检验
        Date time = new Date();// //获取当前校验时间
        String photo = jsonObject.getString("photo");//图片
        Verify verify = new Verify( );
        //属性赋值
        String targetInfo = jsonObject.toString();
        verify.setTargetInfo(targetInfo);//json信息
        verify.setProjectId(projectId);//项目id
        verify.setType(TYPE);//检验方式
        verify.setVerifyTime(time);//获取当前时间
     List<Verify>  verifyList = verifyMapper.selectByWelder(projectId,welderId,null,null,random);/**这里json*/
        //人员
        if (stage.equals(StageEnum.焊前人员.getVerifyName())) {
            verify.setStage(StageEnum.焊前人员.getStage()); //阶段
            /**写死*/
            Boolean flag =true;
            //1.人脸识别校验
            //2.焊工资质有效期判断,查询焊工信息获取
            //失败
            if (!flag) {
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //成功
            this.addSuccessData(verify,null,jsonObject);
        }
        //管材
        if (stage.equals(StageEnum.焊前管材质量.getVerifyName())){

            //管材未校验,进行效验步骤
            Long materialId = jsonObject.getLong("materialId");//管材id
            verify.setStage(StageEnum.焊前管材质量.getStage());
            /**校验*/
            Boolean flag = true;
            if (!flag) {
                //不通过, 添加数据并返回未通过结果
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //校验通过
            this.addSuccessData(verify,null,jsonObject);
        }
        //设备
        if (stage.equals(StageEnum.焊前设备.getVerifyName())){

            verify.setStage(StageEnum.焊前设备.getStage());
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,null,jsonObject);
        }
        //工艺效验
        if (stage.equals(StageEnum.焊接工艺.getVerifyName())){
            //焊口编号是否上传
            String code = jsonObject.getString("code");
            if (StringUtils.isEmpty(code)) {
                return VerifyEnum.未通过.getName();
            }
            //判断人员是否效验通过
            List<Verify> welderList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前人员.getStage( ))).collect(Collectors.toList( ));
            //判断管材是否效验通过
            List<Verify> materialList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前管材质量.getStage( ))).collect(Collectors.toList( ));
            //判断设备是否校验通过
            List<Verify> facilityList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前设备.getStage( ))).collect(Collectors.toList( ));
            if (welderList ==null ||materialList ==null || facilityList ==null || welderList.size()==0 || materialList.size()==0  || facilityList.size()==0) {
                return VerifyEnum.未通过.getName();
            }
            for (Verify v1 : welderList) {
                if (v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            for (Verify v2 : materialList) {
                if (v2.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            for (Verify v3 : facilityList) {
                if (v3.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            //判断这个工艺是否已经校验
            //获取前端传的焊口编号(工艺阶段焊口编号必传)
           /* String code = jsonObject.getString("code");//焊口编号
            if (StringUtils.isEmpty(code)) {
                return VerifyEnum.未通过.getName();
            }
            //通过项目id 用户id 焊口编号来确定工艺阶段
            List<Verify>  list= verifyMapper.selectByWelder(projectId, welderId, code,null);
            List<Verify> collect = list.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊接工艺.getStage( ))).collect(Collectors.toList( ));
            if (collect != null && collect.size()>0) {
                for (Verify v1 : collect) {
                    if (v1 != null) {
                        if (v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (v1.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }
                    }
                }
            }*/
            //如果焊前效验已经通过进行效验步骤
            Boolean flag =false;
            verify.setStage(StageEnum.焊接工艺.getStage());
            String result = jsonObject.getString("result");
            if (VerifyEnum.已通过.getName().equals(result)) {
               flag =true;
            }
            if (!flag) {
                //校验不通过
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,null,jsonObject);
        }
        //耐压
        if (stage.equals(StageEnum.管道耐压.getVerifyName())){
            //查询工艺是否校验通过(可能有好几个焊口码)
            //获取前端传的焊口编号(工艺阶段焊口编号必传)
            String manyCode = jsonObject.getString("manyCode");//获取多个焊口编号
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            String[] codeArray = manyCode.split(",");
            //工艺的效验
            for (String code : codeArray) {
                List<Verify> verifyList1 = verifyMapper.selectByWelder(projectId, welderId, code,StageEnum.焊接工艺.getStage(),null);
                for (Verify verify1 : verifyList1) {
                    //工艺阶段未效验
                    if (verify1 == null) {
                        return VerifyEnum.未通过.getName();
                    }
                    //工艺已校验
                    if (!StringUtils.isEmpty(verify1.getStatus())&&verify1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                        return VerifyEnum.未通过.getName();
                    }
                }
            }
            //管道耐压是否已经校验,获取头部和尾部焊口,耐压之测头部和尾部

                  /*  Verify v = verifyMapper.selectByCode(manyCode, projectId, StageEnum.管道耐压.getStage());
                        if (v !=null && v.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (v !=null && v.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }*/


         /*   if (codeArray !=null && codeArray.length>=2) {
                String  startCode=codeArray[0] ;
                String  endCode = codeArray[codeArray.length-1];
                List<Verify> startList = verifyMapper.selectByWelder(projectId, welderId, startCode,StageEnum.管道耐压.getStage());
                List<Verify> endList = verifyMapper.selectByWelder(projectId, welderId, endCode,StageEnum.管道耐压.getStage());
                if (startList !=null &&endList != null &&startList.size()>0 && endList.size()>0 ) {
                    for (Verify startVerity : startList) {
                        if (startVerity.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (startVerity.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }

                    }
                    for (Verify endVerity : endList) {
                        if (endVerity.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (endVerity.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }
                    }
                }
            }*/
            //如果工艺效验已经通过进行耐压校验步骤,(特别注意,只需要效验头部和尾部耐压)
            verify.setStage(StageEnum.管道耐压.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
               jsonObject.put("code",manyCode);
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,codeArray,jsonObject);
        }
        //埋深
        if (stage.equals(StageEnum.敷设质量.getVerifyName())){

            //查询耐压是否校验通过
            String manyCode = jsonObject.getString("manyCode");//获取多个焊口编号
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify verify1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.管道耐压.getStage( ),null);
            //耐压没有效验数据
            if (verify1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //耐压有效验数据,但是不通过
            if (verify1 != null && verify1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }

            //耐压校验已经通过,埋深是否已经校验
            /*Verify v = verifyMapper.selectByCode(manyCode, projectId, StageEnum.敷设质量.getStage());
            if (v != null) {
                if (v.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
                if (v.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                    return VerifyEnum.已通过.getName();
                }
            }*/
            //耐压校验已经通过,进行埋深校验
            verify.setStage(StageEnum.敷设质量.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
                jsonObject.put("code",manyCode);
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);
        }
         //定位
        if (stage.equals(StageEnum.定位.getVerifyName())){
            //查询埋深是否校验通过
            String manyCode = jsonObject.getString("manyCode");
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify v1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.敷设质量.getStage( ),null);
            //埋深没有效验数据
            if (v1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //埋深有效验数据,但是不通过
            if (v1 != null && v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }
            /*//埋深校验已经通过,定位是否已经校验
            Verify v = verifyMapper.selectByCode(manyCode, projectId, StageEnum.定位.getStage());
            if (v != null) {
                if (v.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
                if (v.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                    return VerifyEnum.已通过.getName();
                }
            }*/
            //耐压校验已经通过,没有埋深数据,进行埋深校验
            verify.setStage(StageEnum.定位.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
                jsonObject.put("code",manyCode);
                QualityProblem qp = new QualityProblem( );
                this.addFailData(verify,jsonObject,qp);
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);
        }
        //回填
        if (stage.equals(StageEnum.回填.getVerifyName())) {
            String manyCode = jsonObject.getString("manyCode");
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify v1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.定位.getStage( ),null);
            //判断定位没有校验数据
            if (v1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //定位有效验数据,但是不通过
            if (v1 != null && v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }
           /* //定位校验已经通过,回填是否已经校验
            Verify v2 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.回填.getStage());
            if (v2 != null) {
                if (v2.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
                if (v2.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                    return VerifyEnum.已通过.getName();
                }
            }*/
            //定位校验已经通过,没有回填数据,进行回填校验
            verify.setStage(StageEnum.回填.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =false ;

            if (!flag) {
                //校验不通过
                jsonObject.put("code",manyCode);
                QualityProblem qualityProblem = new QualityProblem( );
                this.addFailData(verify,jsonObject,qualityProblem);
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);


        }
        return VerifyEnum.已通过.getName();
    }





    /**  cpp
     * 校验失败需要添加的数据
     * @param verify
     * @param qualityProblem
     */
    public void addFailData(Verify verify,JSONObject jsonObject,QualityProblem qualityProblem){
        //校验不通过，存入校验信息，
        verify.setStatus(VerifyEnum.未通过.getStatus());
        try {
            //智能监检管理表添加数据

            boolean save = this.save(verify);
        } catch (Exception e) {
            e.printStackTrace();

        }
        //质量问题表添加数据
        qualityProblem.setProjectId(verify.getProjectId());
        qualityProblem.setSubmitDate(new Date());
        //随机生成四位数
        String random = String.valueOf((int) ((Math.random( ) * 9 + 1) * 1000));
        if (!StringUtils.isEmpty(jsonObject.getString("code"))) {
            String code = jsonObject.getString("code");//获取焊口编码
            qualityProblem.setCode(code+"-WT"+random);
        }
        String stage = jsonObject.getString("stage");//获取效验阶段
        qualityProblem.setGenerateStage(stage);
        qualityProblem.setProblemDescribe(stage+"不通过");
        //获取智能监检表id
        Verify verify1 = verifyMapper.selectByTargetInfo(verify.getTargetInfo( ));
        Long sequenceNbr = verify1.getSequenceNbr( );
        qualityProblem.setStageVerifyId(sequenceNbr);
        qualityProblemService.save(qualityProblem);

    }




    /**   cpp
     * 校验成功需要添加的数据
     * @param verify
     * @param
     */
    public void addSuccessData(Verify verify,String[] codeArray,JSONObject js){
        //效验通过状态
        verify.setStatus(VerifyEnum.已通过.getStatus());

        try {

            //智能监检管理表添加数据
            this.save(verify);
        } catch (Exception e) {
            e.printStackTrace( );
        }
        //焊口表修改状态
        if (codeArray ==null || codeArray.length==0) {
            String targetInfo = verify.getTargetInfo( );
            JSONObject jsonObject = JSONObject.parseObject(targetInfo);
            String code = jsonObject.getString("code");//获取焊口编号
            // 通过焊口码和项目id查询
            if (!StringUtils.isEmpty(code)&& verify.getProjectId() !=null) {

                Weld weld=weldMapper.getWeldByCodeAndProjectId(code, verify.getProjectId());
                if (weld != null) {
                    //判断是哪一个阶段
                    String stage = verify.getStage( );
                    Map<String, String> mapEnum = StageEnum.getStageByNameMap;
                    //修改的值
                    String name = mapEnum.get(stage);
                    weld.setSuperInspecStatus(name);//更改监检状态
                    try {
                        //修改
                        int i = weldMapper.updateById(weld);
                    } catch (Exception e) {
                        e.printStackTrace( );
                    }
                }
            }
        }
        if (codeArray !=null && codeArray.length>0) {
            for (String code : codeArray) {
                if (!StringUtils.isEmpty(code)&& verify.getProjectId() !=null) {
                    Weld weld=weldMapper.getWeldByCodeAndProjectId(code, verify.getProjectId());
                    if (weld != null) {
                        //判断是哪一个阶段
                        String stage = verify.getStage( );
                        Map<String, String> mapEnum = StageEnum.getStageByNameMap;
                        //修改的值
                        String name = mapEnum.get(stage);
                        weld.setSuperInspecStatus(name);//更改监检状态
                        try {
                            //修改
                            int i = weldMapper.updateById(weld);
                        } catch (Exception e) {
                            e.printStackTrace( );
                        }
                    }
                }
            }

        }
    }






    private String 效验状态 = "已存在";
    private final String 问题编码="-WT";
    /**

     * 公共效验接口

     */

    public String effect(JSONObject jsonObject,Integer 效验数量,Boolean i) {

//        String 效验状态 = "已存在";

        Verify verify = new Verify();

        //添加筛选条件

        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();

        //获取target_info

        JSONObject targetInfo = jsonObject.getJSONObject("target_info");

        String code = targetInfo.getString("code");

        //筛选出本焊口监检数

        wrapper.eq(Verify::getCode, code);

        //改焊口焊前数据

        Integer verifyCount = verifyMapper.selectCount(wrapper);

        if (verifyCount == 效验数量) {

            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());

            //该焊口焊前效验通过数据

            Integer integer = verifyMapper.selectCount(wrapper);

            //判断入库数量

            if (integer == 效验数量) {



                verify.setProjectId(jsonObject.getLong("projectId"));

                verify.setCode(jsonObject.getString("code"));

                verify.setTargetInfo(jsonObject.getString("target_info"));

                verify.setSubmitTime(new Date());

                verify.setVerifyTime(new Date());

                verify.setType(VerifyTypeEnum.智能检验.getStatus());

                //获取操作阶段

                String stage = targetInfo.getString("stage");

                verify.setStage(stage);

                //获取效验接口

                if (i) {

                    verify.setStatus(VerifyEnum.已通过.getStatus());

                    //添加筛选条件

                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();

                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));

                    Weld weld = weldMapper.selectOne(wrapperWeld);

                    weld.setSuperInspecStatus(stage);



                    weldService.updateById(weld);



                    效验状态 = "已通过";

                    this.save(verify);

                } else {

                    int math= (int) ((Math.random() * 9 + 1)*1000);

                    verify.setStatus(VerifyEnum.未通过.getStatus());

                    this.save(verify);

                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();

                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));

                    wrapperVerify.eq(Verify::getStage,stage);

                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);

                    QualityProblem qualityProblem = new QualityProblem();
                    //生成问题编码
                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());

                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);

                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));

                    qualityProblem.setGenerateStage(stage);

                    qualityProblem.setSubmitDate(new Date());

                    qualityProblemService.save(qualityProblem);

                    效验状态 = "未通过";
                }
            }
        }
        return 效验状态;
    }



    /**

     * 焊接工艺效验

     */

    private final Integer 焊前效验数量 = 3;



    public String weldEffect(JSONObject jsonObject) {







//        Verify verify = new Verify();

//        //添加筛选条件

//        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();

//        JSONObject targetInfo = jsonObject.getJSONObject("target_info");

//        String code = targetInfo.getString("code");

//        //筛选出本焊口监检数

//        wrapper.eq(Verify::getCode, code);

//        //改焊口焊前数据

//        Integer verifyCount = verifyMapper.selectCount(wrapper);

//        if (verifyCount == 焊前效验数量) {

//            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());

//            //该焊口焊前效验通过数据

//            Integer integer = verifyMapper.selectCount(wrapper);

//            //判断前三次已经入库

//            if (integer == 焊前效验数量) {

//                //获取效验接口

//                Boolean i = false;

//

//

//                verify.setProjectId(jsonObject.getLong("projectId"));

//                verify.setCode(jsonObject.getString("code"));

//                verify.setTargetInfo(jsonObject.getString("target_info"));

//                verify.setSubmitTime(new Date());

//                verify.setStage(StageEnum.焊接工艺.getStage());

//                if (i) {

//                    verify.setStatus(VerifyEnum.已通过.getStatus());

//                    //添加筛选条件

//                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();

//                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));

//                    Weld weld = weldMapper.selectOne(wrapperWeld);

//                    weld.setSuperInspecStatus(StageEnum.焊接工艺.getStage());

//

//                    weldService.updateById(weld);

//

//                    效验状态 = "已通过";

//                    this.save(verify);

//                } else {

//                    int math= (int) (Math.random()*10000);

//                    verify.setStatus(VerifyEnum.未通过.getStatus());

//                    this.save(verify);

//                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();

//                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));

//                    wrapperVerify.eq(Verify::getStage,StageEnum.焊接工艺.getStage());

//                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);

//                    QualityProblem qualityProblem = new QualityProblem();

//                    //生成问题编码

//                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());

//                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);

//                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));

//                    qualityProblem.setGenerateStage(StageEnum.焊接工艺.getStage());

//                    qualityProblem.setSubmitDate(new Date());

//                    qualityProblemService.save(qualityProblem);

//                    效验状态 = "未通过";

//

//                }

//

//            }

//

//

//

//        }

//

        return   effect(jsonObject,焊前效验数量,true);
    }

    /**

     * 管道耐压效验

     */

    private final Integer 管道耐压前效验数量 = 4;

    public String materialEffect(JSONObject jsonObject){





//        Verify verify = new Verify();

//        //添加筛选条件

//        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();

//        //筛选出本焊口监检数

//        wrapper.eq(Verify::getCode, jsonObject.getString("code"));

//        //该焊口焊前数据

//        Integer verifyCount = verifyMapper.selectCount(wrapper);

//        if (verifyCount == 管道耐压前效验数量) {

//            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());

//            //该焊口焊前效验通过数据

//            Integer integer = verifyMapper.selectCount(wrapper);

//            //判断前四次已经入库

//            if (integer == 管道耐压前效验数量) {

//                //获取效验接口

//                Boolean i = true;

//

//

//                verify.setProjectId(jsonObject.getLong("projectId"));

//                verify.setCode(jsonObject.getString("code"));

//                verify.setTargetInfo(jsonObject.getString("target_info"));

//                verify.setSubmitTime(new Date());

//                verify.setStage(StageEnum.焊前管材质量.getStage());

//                if (i) {

//                    verify.setStatus(VerifyEnum.已通过.getStatus());

//                    //添加筛选条件

//                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();

//                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));

//                    Weld weld = weldMapper.selectOne(wrapperWeld);

//                    weld.setSuperInspecStatus(StageEnum.焊前管材质量.getStage());

//

//                    weldService.updateById(weld);

//

//                    效验状态 = "已通过";

//                } else {

//                    int math= (int) (Math.random()*10000);

//                    verify.setStatus(VerifyEnum.未通过.getStatus());

//                    this.save(verify);

//                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();

//                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));

//                    wrapperVerify.eq(Verify::getStage,StageEnum.焊前管材质量.getStage());

//                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);

//                    QualityProblem qualityProblem = new QualityProblem();

//                    //生成问题编码

//                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());

//                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);

//                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));

//                    qualityProblem.setGenerateStage(StageEnum.焊前管材质量.getStage());

//                    qualityProblem.setSubmitDate(new Date());

//                    qualityProblemService.save(qualityProblem);

//                    效验状态 = "未通过";

//

//                }

//

//            }

//

//            save(verify);

//

//        }

//

        return   effect(jsonObject,管道耐压前效验数量,true);

    }

    /**

     * 敷设效验

     */

    private final Integer 敷设效验数量 = 5;

    public String layEffect(JSONObject jsonObject){





//

//        Verify verify = new Verify();

//        //添加筛选条件

//        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();

//        //筛选出本焊口监检数

//        wrapper.eq(Verify::getCode, jsonObject.getString("code"));

//        //该焊口焊前数据

//        Integer verifyCount = verifyMapper.selectCount(wrapper);

//        if (verifyCount == 管道耐压前效验数量) {

//            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());

//            //该焊口焊前效验通过数据

//            Integer integer = verifyMapper.selectCount(wrapper);

//            //判断前四次已经入库

//            if (integer == 管道耐压前效验数量) {

//                //获取效验接口

//                Boolean i = true;

//

//

//                verify.setProjectId(jsonObject.getLong("projectId"));

//                verify.setCode(jsonObject.getString("code"));

//                verify.setTargetInfo(jsonObject.getString("target_info"));

//                verify.setSubmitTime(new Date());

//                verify.setStage(StageEnum.敷设质量.getStage());

//                if (i) {

//                    verify.setStatus(VerifyEnum.已通过.getStatus());

//                    //添加筛选条件

//                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();

//                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));

//                    Weld weld = weldMapper.selectOne(wrapperWeld);

//                    weld.setSuperInspecStatus(StageEnum.敷设质量.getStage());

//

//                    weldService.updateById(weld);

//

//                    效验状态 = "已通过";

//                } else {

//                    int math= (int) (Math.random()*10000);

//                    verify.setStatus(VerifyEnum.未通过.getStatus());

//                    this.save(verify);

//                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();

//                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));

//                    wrapperVerify.eq(Verify::getStage,StageEnum.敷设质量.getStage());

//                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);

//                    QualityProblem qualityProblem = new QualityProblem();

//                    //生成问题编码

//                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());

//                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);

//                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));

//                    qualityProblem.setGenerateStage(StageEnum.敷设质量.getStage());

//                    qualityProblem.setSubmitDate(new Date());

//                    qualityProblemService.save(qualityProblem);

//                    效验状态 = "未通过";

//

//                }

//

//            }

//

//            save(verify);

//

//        }



        return  effect(jsonObject,敷设效验数量,false);

    }



    /**

     * 主键id查询

     * @param sequenceNbr

     * @return

     */

    public OpenDto selectById(Long sequenceNbr){

        Verify verify = verifyMapper.selectById(sequenceNbr);
        OpenDto openDto = new OpenDto( );
        if (verify !=null && !StringUtils.isEmpty( verify.getStatus())) {
            String targetInfo=  verify.getTargetInfo();
            //获取照片
            openDto.setNewPhoto("https://img2.baidu.com/it/u=806791452,2765805606&fm=253&fmt=auto&app=138&f=JPEG?w=350&h=500");
            openDto.setOldPhoto("https://img2.baidu.com/it/u=1534411088,173440019&fm=253&app=138&size=w931&n=0&f=JPEG&fmt=auto?sec=1666976400&t=3e985017d01fe1c0cfe639335abc2fe8");
            if (verify.getStatus().equals("0")) {
                openDto.setResult(VerifyEnum.未通过.getName());
            }
            if (verify.getStatus().equals("1")) {
                openDto.setResult(VerifyEnum.已通过.getName());
            }



            //符合性
            openDto.setAccord("符合");
            //有效性
            openDto.setValid("有效");
        }
        return openDto ;
    }

    /**

     * 评价

     * @return

     */
    private static final String  CONFORM ="符合";
    private static final String  NOTCONFORM ="不符合";

    public Boolean evaluate(JSONObject jsonObject) {

        MyPqr pqr = new MyPqr( );
        MyWps wps = new MyWps( );
        // 初始化
        Boolean flag = false;
        HashMap<String, String> stringStringHashMap = null;
        String stage = jsonObject.getString("stage");
        if (!StringUtils.isEmpty(stage)) {
            pqr.setWelding_method(jsonObject.getString("pqr_welding_method"));
            pqr.setMaterial_a_number(jsonObject.getString("pqr_material_a_number"));
            pqr.setMaterial_a_class(jsonObject.getString("pqr_material_a_class"));
            pqr.setMaterial_a_thickness(jsonObject.getDouble("pqr_material_a_thickness"));
            pqr.setMaterial_a_group(jsonObject.getString("pqr_material_a_group"));
            pqr.setMaterial_a_standard(jsonObject.getString("pqr_material_a_standard"));
            pqr.setMaterial_b_number(jsonObject.getString("pqr_material_b_number"));
            pqr.setMaterial_b_class(jsonObject.getString("pqr_material_b_class"));
            pqr.setMaterial_b_thickness(jsonObject.getDouble("pqr_material_b_thickness"));
            pqr.setMaterial_b_group(jsonObject.getString("pqr_material_b_group"));
            pqr.setMaterial_b_standard(jsonObject.getString("pqr_material_b_standard"));
            pqr.setIf_shock(jsonObject.getString("pqr_if_shock"));
            pqr.setIf_bend(jsonObject.getString("pqr_if_bend"));
            pqr.setGtaw_weld_material_class(jsonObject.getString("pqr_gtaw_weld_material_class"));
            pqr.setSmaw_weld_material_class(jsonObject.getString("pqr_smaw_weld_material_class"));
            pqr.setSaw_weld_material_class_1(jsonObject.getString("pqr_saw_weld_material_class_1"));
            pqr.setSaw_weld_material_class_2(jsonObject.getString("pqr_saw_weld_material_class_2"));
            pqr.setGmaw_weld_material_class(jsonObject.getString("pqr_gmaw_weld_material_class"));
            pqr.setIf_heat_treatment(jsonObject.getString("pqr_if_heat_treatment"));
            pqr.setTemperature(jsonObject.getDouble("pqr_temperature"));
            pqr.setCombox_type(jsonObject.getString("pqr_combox_type"));
            pqr.setTemperature_time(jsonObject.getDouble("pqr_temperature_time"));
            pqr.setMaterial_minT_of_a_b_thickness(jsonObject.getDouble("pqr_material_minT_of_a_b_thickness"));



            wps.setWelding_method(jsonObject.getString("wps_welding_method"));
            wps.setMaterial_a_number(jsonObject.getString("wps_material_a_number"));
            wps.setMaterial_a_class(jsonObject.getString("wps_material_a_class"));
            wps.setMaterial_a_thickness(jsonObject.getDouble("wps_material_a_thickness"));
            wps.setMaterial_a_group(jsonObject.getString("wps_material_a_group"));
            wps.setMaterial_a_standard(jsonObject.getString("wps_material_a_standard"));
            wps.setMaterial_b_number(jsonObject.getString("wps_material_b_number"));
            wps.setMaterial_b_class(jsonObject.getString("wps_material_b_class"));
            wps.setMaterial_b_thickness(jsonObject.getDouble("wps_material_b_thickness"));
            wps.setMaterial_b_group(jsonObject.getString("wps_material_b_group"));
            wps.setMaterial_b_standard(jsonObject.getString("wps_material_b_standard"));
            wps.setIf_shock(jsonObject.getString("wps_if_shock"));
            wps.setIf_bend(jsonObject.getString("wps_if_bend"));
            wps.setGtaw_weld_material_class(jsonObject.getString("wps_gtaw_weld_material_class"));
            wps.setSmaw_weld_material_class(jsonObject.getString("wps_smaw_weld_material_class"));
            wps.setSaw_weld_material_class_1(jsonObject.getString("wps_saw_weld_material_class_1"));
            wps.setSaw_weld_material_class_2(jsonObject.getString("wps_saw_weld_material_class_2"));
            wps.setGmaw_weld_material_class(jsonObject.getString("wps_gmaw_weld_material_class"));
            wps.setIf_heat_treatment(jsonObject.getString("wps_if_heat_treatment"));
            wps.setTemperature(jsonObject.getDouble("wps_temperature"));
            wps.setCombox_type(jsonObject.getString("wps_combox_type"));
            wps.setTemperature_time(jsonObject.getDouble("wps_temperature_time"));
            wps.setMaterial_minT_of_a_b_thickness(jsonObject.getDouble("wps_material_minT_of_a_b_thickness"));
        }

        stringStringHashMap = new WeldingQualification( ).equipmentWeldingQualification(pqr, wps);

        ArrayList<String> list = new ArrayList<>( );

        for(String key:stringStringHashMap.keySet()){

            String vaule = stringStringHashMap.get(key);

            //如果不是空串

            if (vaule !=null&&!vaule.equals("")) {

                list.add(vaule);

            }
        }

        // 获取不符合的

        List<String> notconform = list.stream( ).filter(b -> b.equals(NOTCONFORM)).collect(Collectors.toList( ));

        if (notconform ==null && notconform.size()==0) {

            //没有不符合的,更改状态
            flag =true;

        }
        return flag;

    }






}
