package com.yeejoin.amos.boot.biz.common.feign;

import com.yeejoin.amos.boot.biz.common.dto.OptionDto;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 平台Feign service
 *
 * @author tb
 */
@Service
public class AmosFeignService {

    private final Logger logger = LogManager.getLogger(AmosFeignService.class);

    /**
     * 根据dictCode从平台获取数据字典
     *
     * @param dictCode
     * @return
     */
    public List<DictionarieValueModel> listDictionaryByDictCode(String dictCode) throws Exception {
        logger.info("===========>listDictionaryByDictCode方法请求参数：{}", dictCode);
        List<DictionarieValueModel> dictionaryModel;

        dictionaryModel = FeignUtil.remoteCall(() -> Systemctl.dictionarieClient.dictValues(dictCode));
        return dictionaryModel;
    }

    /**
     * 根据Code查询指定的字典信息.
     *
     * @param dictCode
     * @param isScreen 是否过滤数据
     * @return
     */
    public List<OptionDto> listDictionaryByDictCode(String dictCode, boolean isScreen) {
        List<DictionarieValueModel> dictionarieModel = null;
        try {
            dictionarieModel = FeignUtil.remoteCall(() -> Systemctl.dictionarieClient.dictValues(dictCode));
            return getOptionsMo(dictionarieModel, isScreen);
        } catch (Exception e) {
            throw new RuntimeException("获取字典数据出错");
        }
    }

    /**
     * 返回数据转成key - value键值对
     *
     * @param dictionariesModel
     * @param isScreen 是否过滤数据
     * @return
     */
    private List<OptionDto> getOptionsMo(List<DictionarieValueModel> dictionariesModel, boolean isScreen) {
        List<OptionDto> optionsMoList = new ArrayList();
        dictionariesModel.forEach(
                dictionaries -> {
                    if (isScreen && ObjectUtils.isEmpty(dictionaries.getDictDataDesc())) {
                        return;
                    }
                    OptionDto optionsMo = new OptionDto();
                    optionsMo.setKey(dictionaries.getDictDataKey());
                    optionsMo.setLabel(dictionaries.getDictDataValue());
                    optionsMo.setLabelDesc(dictionaries.getDictDataDesc());
                    optionsMoList.add(optionsMo);
                }
        );
        return optionsMoList;
    }

    /**
     * 根据用户id查询指定平台用户信息.
     *
     * @param userId
     * @return
     */
    public AgencyUserModel queryAgencyUserByUserId(String userId) {
        AgencyUserModel userModel = null;
        try {
            userModel = FeignUtil.remoteCall(() -> Privilege.agencyUserClient.queryByUserId(userId));
            return userModel;
        } catch (Exception e) {
            throw new RuntimeException("获取平台用户数据出错");
        }
    }
}
