package com.yeejoin.amos.boot.biz.config;

import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

@MappedJdbcTypes(JdbcType.BIT)
public class BitTypeHandler extends BaseTypeHandler<Boolean> {
	@Override
	public void setNonNullParameter(PreparedStatement ps, int i, Boolean parameter, JdbcType jdbcType)
			throws SQLException {
		//原生的boolean会再sql上加上引号比如'0'或者'1',人大金仓不支持,支持不带引号的
		//ps.setBoolean(i, parameter);
		ps.setInt(i, parameter?1:0);
	}

	@Override
	public Boolean getNullableResult(ResultSet rs, String columnName) throws SQLException {
		return rs.getBoolean(columnName);
	}

	@Override
	public Boolean getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
		return rs.getBoolean(columnIndex);
	}

	@Override
	public Boolean getNullableResult(java.sql.CallableStatement cs, int columnIndex) throws SQLException {
		return cs.getBoolean(columnIndex);
	}
}
