package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 设备施工告知信息
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_construction_info")
public class SpecialConstructionInfo extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 设备全省唯一编号
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 告知单ID
	 */
	@TableField("info_id")
	private String infoId;
	/**
	 * 施工类别
	 */
	@TableField("construct_category")
	private String constructCategory;
	/**
	 * 设备名称
	 */
	@TableField("equ_name")
	private String equName;
	/**
	 * 告知单编号
	 */
	@TableField("info_code")
	private String infoCode;
	/**
	 * 注册登记机构
	 */
	@TableField("register_org")
	private String registerOrg;
	/**
	 * 签收日期
	 */
	@TableField("sign_date")
	private String signDate;
	/**
	 * 设备地点
	 */
	@TableField("equ_address")
	private String equAddress;
	/**
	 * 设备注册代码
	 */
	@TableField("equ_register_code")
	private String equRegisterCode;
	/**
	 * 设备型号
	 */
	@TableField("equ_type")
	private String equType;
	/**
	 * 出厂编号
	 */
	@TableField("factory_code")
	private String factoryCode;
	/**
	 * 设备所在地区代码
	 */
	@TableField("equ_region_code")
	private String equRegionCode;
	/**
	 * 设备代码
	 */
	@TableField("equ_code")
	private String equCode;
	/**
	 * 设备制造单位名称
	 */
	@TableField("equ_manufacture_unit_name")
	private String equManufactureUnitName;
	/**
	 * 许可证编号
	 */
	@TableField("equ_licence_num")
	private String equLicenceNum;
	/**
	 * 安装改造维修日期
	 */
	@TableField("install_reform_repair_date")
	private String installReformRepairDate;
	/**
	 * 安装竣工日期
	 */
	@TableField("install_completed_date")
	private String installCompletedDate;
	/**
	 * 施工单位
	 */
	@TableField("construct_unit")
	private String constructUnit;
	/**
	 * 施工单位ID
	 */
	@TableField("construct_unit_id")
	private String constructUnitId;
	/**
	 * 许可证编号（或受理编号）
	 */
	@TableField("construct_licence_num")
	private String constructLicenceNum;
	/**
	 * 施工单位社会信用代码
	 */
	@TableField("construct_unit_credit_code")
	private String constructUnitCreditCode;
	/**
	 * 施工单位联系人
	 */
	@TableField("construct_unit_contacts")
	private String constructUnitContacts;
	/**
	 * 施工单位邮编
	 */
	@TableField("construct_unit_code")
	private String constructUnitCode;
	/**
	 * 施工单位电话
	 */
	@TableField("construct_unit_phone")
	private String constructUnitPhone;
	/**
	 * 施工单位传真
	 */
	@TableField("construct_unit_fax")
	private String constructUnitFax;
	/**
	 * 施工单位地址
	 */
	@TableField("construct_unit_address")
	private String constructUnitAddress;
	/**
	 * 许可证有效期
	 */
	@TableField("construct_licence_validity")
	private String constructLicenceValidity;
	/**
	 * 使用单位名称
	 */
	@TableField("use_unit_name")
	private String useUnitName;
	/**
	 * 使用单位系统ID
	 */
	@TableField("use_unit_system_id")
	private String useUnitSystemId;
	/**
	 * 使用单位社会信用代码
	 */
	@TableField("use_unit_credit_code")
	private String useUnitCreditCode;
	/**
	 * 使用单位联系人
	 */
	@TableField("use_unit_contacts")
	private String useUnitContacts;
	/**
	 * 使用单位电话
	 */
	@TableField("use_unit_phone")
	private String useUnitPhone;
	/**
	 * 使用单位传真
	 */
	@TableField("use_unit_fax")
	private String useUnitFax;
	/**
	 * 使用单位地址
	 */
	@TableField("use_unit_address")
	private String useUnitAddress;
	/**
	 * 使用单位邮编
	 */
	@TableField("use_unit_code")
	private String useUnitCode;
	/**
	 * 告知日期
	 */
	@TableField("info_date")
	private String infoDate;
	/**
	 * 注册状态
	 */
	@TableField("register_state")
	private String registerState;
	/**
	 * 使用状态
	 */
	@TableField("use_state")
	private String useState;

}
