package com.yeejoin.amos.api.openapi.face.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialVehicleModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.SpecialVehicleMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.SpecialVehicle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 厂(场)内机动车辆 服务类
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@Component
public class SpecialVehicleService
                extends BaseService<SpecialVehicleModel, SpecialVehicle, SpecialVehicleMapper> {

        /**
         * 分页查询
         */
        public Page<SpecialVehicleModel> queryForTmSpecialVehiclePage(Page<SpecialVehicleModel> page, String agencyCode) {
                return this.queryForPage(page, null, false, agencyCode);
        }

        /**
         * 列表查询 示例
         */
        public List<SpecialVehicleModel> queryForTmSpecialVehicleList(String agencyCode) {
                return this.queryForList("", false, agencyCode);
        }

		public String createSpecialVehicle(List<SpecialVehicleModel> model) {
			// TODO Auto-generated method stub
			if (ValidationUtil.isEmpty(model))
				throw new BadRequest("厂(场)内机动车辆 数据为空.");
	    	
			for (SpecialVehicleModel specialVehicleModel : model) {
				specialVehicleModel.setRecDate(new Date());
				specialVehicleModel.setAppId(getAppId());
				this.createWithModel(specialVehicleModel);
			}
			return "OK";
		}
		private String getAppId() {
			String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
	    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
	    	return bizTokenModel.getAppId();
		}
	    @Autowired
	    private RedisTemplate redisTemplate;
}
