package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 隐患信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("asf_fire_latent_danger")
public class FireLatentDanger extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 风险点id
     */
    @TableField("danger_mrid")
    private String dangerMrid;

    /**
     * 风险点名称
     */
    @TableField("danger_name")
    private String dangerName;

    /**
     * 隐患状态:隐患状态（1：待评审；2：待治理；3：安措计划中；4：待验证；5：治理完毕；6：已撤销；7：延期治理中；8：延期治理待车间部门审核；9：延期治理待公司审核'
     */
    @TableField("danger_state")
    private String dangerState;

    /**
     * 隐患状态名称
     */
    @TableField("danger_state_name")
    private String dangerStateName;

    /**
     * 隐患类型枚举(1：无码无计划隐患；2：巡检隐患；3：有码无计划隐患；4：随手拍）
     */
    @TableField("danger_type")
    private String dangerType;

    /**
     * 隐患类型名称
     */
    @TableField("danger_type_name")
    private String dangerTypeName;

    /**
     * 隐患等级（1：一般隐患；2：重大隐患）
     */
    @TableField("danger_level")
    private String dangerLevel;

    /**
     * 隐患等级名称
     */
    private String dangerLevelName;

    /**
     * 隐患提交时间
     */
    @TableField("discovery_date")
    private Date discoveryDate;

    /**
     * 处理状态:1-未完成；2-已完成
     */
    @TableField("deal_state")
    private Integer dealState;

    /**
     * 治理日期
     */
    @TableField("deal_date")
    private Date dealDate;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

}
