package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 风险点表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("asf_fire_risk_source")
public class FireRiskSource extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 唯一标识
     */
    @TableField("mrid")
    private String mrid;

    /**
     * 装备名称
     */
    @TableField("name")
    private String name;

    /**
     * 上级编号id
     */
    @TableField("parent_mrid")
    private String parentMrid;

    /**
     * 风险等级id
     */
    @TableField("risk_level_mrid")
    private String riskLevelMrid;

    /**
     * 风险等级名称
     */
    @TableField("risk_level_name")
    private String riskLevelName;

    /**
     * 风险等级颜色
     */
    @TableField("risk_level_color")
    private String riskLevelColor;

    /**
     * rpni属性
     */
    @TableField("rpni")
    private BigDecimal rpni;

    /**
     * 实时rpn
     */
    @TableField("rpn")
    private BigDecimal rpn;

    /**
     * 状态(正常normal，异常anomaly)
     */
    @TableField("status")
    private String status;

    /**
     * rpn增量
     */
    @TableField("increment")
    private BigDecimal increment;

    /**
     *
     */
    @TableField("is_region")
    private String isRegion;

}
