package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author fengwang
 * @date 2021-06-18.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OrgUsr对象", description = "人员信息")
public class OrgPersonExcelDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "姓名", index = 0)
    @ApiModelProperty(value = "人员名称")
    private String bizOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "人员编码")
    private String bizOrgCode;

    @ExcelProperty(value = "关联账户", index = 1)
    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ExcelIgnore
    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType = CommonConstant.BIZ_ORG_TYPE_PERSON;

    @ExcelProperty(value = "所属单位/部门", index = 2)
    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @ExcelProperty(value = "员工编号", index = 3)
    @ApiModelProperty(value = "员工编号")
    private String personNumber;

    @ExplicitConstraint(type = "XB", indexNum = 4, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "性别", index = 4)
    @ApiModelProperty(value = "性别")
    private String gender;

    @ExcelIgnore
    @ApiModelProperty(value = "性别code")
    private String genderCode;

    @ExplicitConstraint(type = "RYZJLX", indexNum = 5, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "证件类型", index = 5)
    @ApiModelProperty(value = "证件类型")
    private String certificatesType;

    @ExcelIgnore
    @ApiModelProperty(value = "证件类型code")
    private String certificatesTypeCode;

    @ExcelProperty(value = "证件号码", index = 6)
    @ApiModelProperty(value = "证件号码")
    private String certificatesNumber;

    @ExcelProperty(value = "联系电话", index = 7)
    @ApiModelProperty(value = "联系电话")
    private String telephone;

    @ExplicitConstraint(type = "RYZT", indexNum = 8, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "人员状态", index = 8)
    @ApiModelProperty(value = "人员状态")
    private String state;

    @ExcelIgnore
    @ApiModelProperty(value = "人员状态code")
    private String stateCode;

    @ExplicitConstraint(type = "AQPX", indexNum = 9, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "是否进行安全培训", index = 9)
    @ApiModelProperty(value = "是否进行安全培训")
    private String safetyTraining;

    @ExcelIgnore
    @ApiModelProperty(value = "是否进行安全培训code")
    private String safetyTrainingCode;

    @ExplicitConstraint(type = "XZZW", indexNum = 10, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "行政职务", index = 10)
    @ApiModelProperty(value = "行政职务")
    private String administrativePosition;

    @ExcelIgnore
    @ApiModelProperty(value = "行政职务code")
    private String administrativePositionCode;

    @ExplicitConstraint(type = "JGNBZW", indexNum = 11, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "消防管理组织机构内部职务", index = 11)
    @ApiModelProperty(value = "消防管理组织机构内部职务")
    private String internalPosition;

    @ExcelIgnore
    @ApiModelProperty(value = "消防管理组织机构内部职务code")
    private String internalPositionCode;

    @ExplicitConstraint(type = "XFGLGW", indexNum = 12, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "消防管理岗位", index = 12)
    @ApiModelProperty(value = "消防管理岗位")
    private String fireManagementPost;

    @ExcelIgnore
    @ApiModelProperty(value = "消防管理岗位code")
    private String fireManagementPostCode;

    @ExplicitConstraint(type = "GWMC", indexNum = 13, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "岗位类型", index = 13)
    @ApiModelProperty(value = "岗位类型")
    private String positionType;

    @ExcelIgnore
    @ApiModelProperty(value = "岗位类型code")
    private String positionTypeCode;

    @ExplicitConstraint(type = "CZLB", indexNum = 14, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "持证类别", index = 14)
    @ApiModelProperty(value = "持证类别")
    private String certificateType;

    @ExcelIgnore
    @ApiModelProperty(value = "持证类别code")
    private String certificateTypeCode;

    @ExcelProperty(value = "持证时间", index = 15)
    @ApiModelProperty(value = "持证时间")
    private Date holdingTime;

    @ExplicitConstraint(type = "SHZQ", indexNum = 16, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "审核周期", index = 16)
    @ApiModelProperty(value = "审核周期")
    private String auditCycle;

    @ExcelIgnore
    @ApiModelProperty(value = "审核周期code")
    private String auditCycleCode;

    @ExcelProperty(value = "人员照片", index = 17)
    @ApiModelProperty(value = "人员照片")
    private String personImg;

    @ExcelProperty(value = "重点工种资质证书", index = 18)
    @ApiModelProperty(value = "重点工种资质证书")
    private String certificateImg;

    @ExcelIgnore
    @ApiModelProperty(value = "更新人")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String recUserName;
}
