package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 单位归属
 *
 * @author gaojianqiang
 * @date 2021-08-19
 */
@Data
@ApiModel(value = "UserDto", description = "用户信息")
public class UserDto {

    @ApiModelProperty(value = "人员类型1-维保公司；2-业主单位")
    private String identityType;

    @ApiModelProperty(value = "人员id")
    private String personSeq;

    @ApiModelProperty(value = "人员名称")
    private String personName;

    @ApiModelProperty(value = "公司id")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "字段名")
    private String fieldCode;

    @ApiModelProperty(value = "字段值")
    private String fieldValue;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType;
    @ApiModelProperty(value = "所在单位是部门时，获取部门上级公司code")
    private String companyBizOrgCode;

}
