package com.yeejoin.amos.boot.module.common.api.excel;



import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: mypro
 * @description: todo
 * @author: xuYao2
 * @create: 2022-07-22 13:35
 **/
@Data
@Slf4j
public class ExcelSelectedResolve {
    /**
     * 下拉内容
     */
    private String[] source;

    /**
     * 设置下拉框的起始行，默认为第二行
     */
    private int firstRow;

    /**
     * 设置下拉框的结束行，默认为最后一行
     */
    private int lastRow;

    public String[] resolveSelectedSource(ExplicitConstraint excelSelected, DataSources dataDictionaryMapper) {
        if (excelSelected == null) {
            return null;
        }

        // 获取固定下拉框的内容
        String[] source = excelSelected.source();
        if (source.length > 0) {
            return source;
        }

        // 获取动态下拉框的内容
        Class<? extends ExplicitInterface>[] classes = excelSelected.sourceClass();
        if (classes.length > 0) {
            try {
                ExplicitInterface explicitInterface = classes[0].newInstance();
                String[] dynamicSelectSource = explicitInterface.source(excelSelected.type(), excelSelected.method(),
                         dataDictionaryMapper);
                if (dynamicSelectSource != null && dynamicSelectSource.length > 0) {
                    return dynamicSelectSource;
                }
            } catch (Exception e) {
                log.error("解析动态下拉框数据异常", e);
            }
        }
        return null;
    }
}
