package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.config.BitTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: GeographicalRegion
 * @Author: Jianqiang Gao
 * @Description: 建筑
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("building")
@ApiModel(value = "Building对象", description = "建筑数据")
public class Building implements Serializable {

    private static final long serialVersionUID = -5299830808658313046L;

    @ApiModelProperty(value = "ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "CIM的ID")
    @TableField("mrid")
    private String mRid;

    @ApiModelProperty(value = "名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "中文描述")
    @TableField("description")
    private String description;

    @ApiModelProperty(value = "使用性质")
    @TableField("usepurpose")
    private String usePurpose;

    @ApiModelProperty(value = "设计单位")
    @TableField("designunit")
    private String designUnit;

    @ApiModelProperty(value = "施工单位")
    @TableField("constructionunit")
    private String constructionUnit;

    @ApiModelProperty(value = "建筑日期")
    @TableField("builddate")
    private Date buildDate;

    @ApiModelProperty(value = "消防验收日期")
    @TableField("fireinspectiondate")
    private Date fireInspectionDate;

    @ApiModelProperty(value = "空间位置信息")
    @TableField("coordinates")
    private String coordinates;

    @ApiModelProperty(value = "高度")
    @TableField("height")
    private BigDecimal height;

    @ApiModelProperty(value = "长度")
    @TableField("height")
    private BigDecimal length;

    @ApiModelProperty(value = "对角坐标标识")
    @TableField(value = "rect",typeHandler = BitTypeHandler.class)
    private Boolean rect;

    @ApiModelProperty(value = "建筑占地面积")
    @TableField("area")
    private BigDecimal area;

    @ApiModelProperty(value = "建筑平面图")
    @TableField("plan")
    private String plan;

    @ApiModelProperty(value = "建筑立面图")
    @TableField("elevations")
    private String elevations;

    @ApiModelProperty(value = "地上层数")
    @TableField("abovegroundfloors")
    private Integer abovegroundFloors;

    @ApiModelProperty(value = "地下层数")
    @TableField("undergroundfloors")
    private Integer undergroundFloors;

    @ApiModelProperty(value = "耐火等级")
    @TableField("fireresistancerating")
    private String fireResistanceRating;

    @ApiModelProperty(value = "所属区域标识")
    @TableField("regionid")
    private String regionId;

    @ApiModelProperty(value = "建筑类型，取自groupCode")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "上限")
    @TableField("upperlimit")
    private String upperLimit;

    @ApiModelProperty(value = "下限")
    @TableField("inferiorlimit")
    private String inferiorLimit;

}