package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.config.BitTypeHandler;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_building_audit")
@ApiModel(value = "audit对象", description = "建筑审核")
public class BuildingAudit  extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "审核类型")
    @TableField(value = "audit_type_id")
    private String auditTypeId;

    @ApiModelProperty(value = "审核类型名称")
    @TableField(value = "audit_type_name")
    private String auditTypeName;

    @ApiModelProperty(value = "审核单位")
    @TableField(value = "audit_unit")
    private String auditUnit;

    @ApiModelProperty(value = "建筑id")
    @TableField(value = "building_id")
    private Long buildingId;

    @ApiModelProperty(value = "建筑名称")
    @TableField(value = "building_name")
    private String buildingName;
;
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "审核时间")
    @TableField(value = "audit_time")
    private Date auditTime;

    @ApiModelProperty(value = "是否删除:0-否；1-是")
    @TableField(value = "is_delete",typeHandler = BitTypeHandler.class)
    private Boolean isDelete;

    @ApiModelProperty(value = "单位编码")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String orgCode;

    @ApiModelProperty(value = "创建人id")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long creatorId;
}
