package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_on_car")
@ApiModel(value = "EquipmentOnCar对象", description = "")
public class EquipmentOnCar extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 车辆ID
     */
    private Long carId;

    /**
     * 设备模板ID
     */
    private Long equipmentDetailId;
    /**
     * 库存详情id
     */
    private Long stockDetailId;
    /**
     * 库存数量
     */
    private Double amount;

    /**
     * 设备实例ID
     */
    private Long equipmentSpecificId;
}
