package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;


@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsr对象", description="部门信息")
public class OrgUsr {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型`")
    private String bizOrgType;

    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;

    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @ApiModelProperty(value = "扩展属性1")
    private String orgExpandAttr1;

    @ApiModelProperty(value = "扩展属性2")
    private String orgExpandAttr2;

    @ApiModelProperty(value = "扩展属性3")
    private String orgExpandAttr3;

    @ApiModelProperty(value = "扩展属性4")
    private String orgExpandAttr4;

    private String orgExpandAttr5;

    private String orgExpandAttr6;

    private String orgExpandAttr7;

    private String orgExpandAttr8;

    @ApiModelProperty(value = "省市区code,用逗号分隔")
    private String pczCode;

    @ApiModelProperty(value = "省市区名称,用逗号分隔")
    private String pczName;

    @ApiModelProperty(value = "唯一编号")
    private String code;

    @ApiModelProperty(value = "数量")
    @TableField(exist = false)
    private Long total;
    
    @ApiModelProperty(value = "管理类别")
    @TableField(exist = false)
    private String managementType;


    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @TableField(value = "rec_date", fill = FieldFill.INSERT_UPDATE)
    protected Date recDate;

    @TableField(value = "rec_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String recUserId;

    @TableField(value = "rec_user_name", fill = FieldFill.INSERT_UPDATE)
    protected String recUserName;

    /**
     * 是否删除
     */
    @TableField(value = "is_delete")
    public Boolean isDelete=false;

    @ApiModelProperty(value = "是否可以点击")
    @TableField(exist = false)
    public Boolean canClick;
}