package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;
/**
 * 计量单位
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_unit")
@ApiModel(value="Unit对象", description="计量单位")
public class Unit extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位名称")
    private String name;

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "上级单位ID")
    private Long parentId;

    @ApiModelProperty(value = "描述")
    private String description;
    
    @TableField(exist=false)
    private boolean hasLowerClassification;      
    
    @TableField(exist=false)
    private List<Unit> children = new ArrayList<>(); 



}
