package com.yeejoin.equipmanage.common.enums;

/**
 * <pre>
 *  库存单据类型
 * </pre>
 *
 * @author as-chennan
 * @version StockBillTypeEnum.java v0.1  
 * @time 2017年5月31日 下午3:07:25
 */
public enum StockBillTypeEnum {
	
	DBRK("DBRK", "1", "调拨入库"),
	QTRK("QTRK", "2", "其它入库"),
	DBCK("DBCK", "3", "调拨出库"),
	SHCK("SHCK", "4", "损耗出库"),
	BFCK("BFCK", "5", "报废出库"),
	QTCK("QTCK", "6", "其他出库"),
	JYRK("JYRK", "7", "借用入库"),
	JYCK("JYCK", "8", "借用出库"),
	GHRK("GHRK", "9", "归还入库"),
	GHCK("GHCK", "10", "归还出库");
	
	private String describe;
	
	private String name;
	
	private String value;
	
	private StockBillTypeEnum(String name, String value, String describe) {
		this.name = name;
		this.value = value;
		this.describe = describe;
	}
	
	public String getDescribe() {
		return describe;
	}

	public void setDescribe(String describe) {
		this.describe = describe;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
	
	public static StockBillTypeEnum getEnum(String code) {  
        for (StockBillTypeEnum type : StockBillTypeEnum.values()) {  
            if (type.getValue().equals(code)) {  
                return type;  
            }  
        }  
        return null;  
	}  
}
