package com.yeejoin.equipmanage.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class MyNode {
	private String id;
	private int level = -1;
	private String text;
	private List<MyNode> children = new ArrayList<>();
	private MyNode parent;
	private String pageInfo;
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public int ggLevel() {
		return level;
	}
	public void setLevel(int level) {
		this.level = level;
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public List<MyNode> getChildren() {
		return children;
	}
	public void setChildren(List<MyNode> children) {
		this.children = children;
	}
	public MyNode ggParent() {
		return parent;
	}
	public void setParent(MyNode parent) {
		this.parent = parent;
	}
	public Map<String,String> getAttributes(){
		Map<String,String> map =new HashMap<>();
		map.put("id", id);
		return map;
	}
	public void append(String s,int level) {
		MyNode n = new MyNode(s,level);
		n.setParent(this);
		children.add(n);
	}
	public void append(MyNode n) {
		n.setParent(this);
		children.add(n);
	}
	public MyNode(String text, int level) {
		super();
		this.text = text;
		this.level = level;
	}
	public MyNode() {
		super();
		// TODO Auto-generated constructor stub
	}
	@Override
	public String toString() {
		return "MyNode [id=" + id + ", text=" + text + ", children=" + children + "]";
	}
	public String getPageInfo() {
		return pageInfo;
	}
	public void setPageInfo(String pageInfo) {
		this.pageInfo = pageInfo;
	}
	
	
}
