package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanTaskDetailStatusEnum {
	
	NOTSTARTED("未开始","0"),
	QUALIFIED("合格","1"),
	UNQUALIFIED("不合格","2"),
	OMISSION("漏检","3");
	
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private String type;
	


	private PlanTaskDetailStatusEnum(String name, String type) {
		this.name = name;
		this.type = type;
	}


	public static String getName(String type) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (type.equals(c.getType())) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getType(String name) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c.type;
			}
		}
		return "";
	}


	public static PlanTaskDetailStatusEnum getEnumByType(String type) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (type.equals(c.getType())) {
				return c;
			}
		}
		return null;
	}


	public static PlanTaskDetailStatusEnum getEnumByName(String name) {
		for (PlanTaskDetailStatusEnum c : PlanTaskDetailStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<Map<String,Object>> getEnumList() {
		List<Map<String,Object>> nameList = new ArrayList<>();
		for (PlanTaskDetailStatusEnum c: PlanTaskDetailStatusEnum.values()) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("name", c.getName());
			map.put("type", c.getType() +"");
			nameList.add(map);
		}
		return nameList;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PlanTaskDetailStatusEnum c: PlanTaskDetailStatusEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}
	
	public static List<Map<String,String>> getErrorLevelEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (PlanTaskDetailStatusEnum c: PlanTaskDetailStatusEnum.values()) {
			if(!c.getName().equals("合格")) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("name", c.getName());
				map.put("level", c.getType() +"");
				nameList.add(map);
			}
		}
		return nameList;
	}
}
