package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;

/**
 * 打卡记录
 *
 * @author system_generator
 * @date 2022-08-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="SignDto", description="打卡记录")
public class SignDto  extends BaseDto {


    @ExcelIgnore
    @ApiModelProperty(value = "打卡人照片")
    private String personPhotos;
    @ExcelIgnore
    @ApiModelProperty(value = "当前页")
    private int current;

    @ExcelIgnore
    @ApiModelProperty(value = "每页几条")
    private int size;

    @ExcelProperty(value = "打卡人", index = 1)
    @ApiModelProperty(value = "打卡人名字")
    private String name;

    @ExcelIgnore
    @ApiModelProperty(value = "打卡人id")
    private String signUserId;

    @ExcelProperty(value = "岗位", index = 2)
    @ApiModelProperty(value = "打卡人岗位")
    private String jobTitle;

    @ExcelIgnore
    @ApiModelProperty(value = "换流站code")
    private String bizOrgCode;

    @ExcelProperty(value = "换流站", index = 0)
    @ApiModelProperty(value = "换流站Name")
    private String bizOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "打卡时间")
    private String date;
    @ExcelIgnore
    @ApiModelProperty(value = "打卡来源")
    private String source;

    @ExcelIgnore
    @ApiModelProperty(value = "打卡图片")
    private String photos;

    @ExcelProperty(value = "备注", index = 5)
    @ApiModelProperty(value = "备注")
    private String remarks;

    @ExcelProperty(value = "打卡时间", index = 4)
    @ApiModelProperty(value = "打卡时间")
    private Date signTime;

    @ExcelIgnore
    @ApiModelProperty(value = "系统标识（数据隔离使用）")
    private String appKey;
    @ExcelIgnore
    @ApiModelProperty(value = "组件机构")
    private String orgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "开始时间")
    private String signTimeBIGGER;

    @ExcelIgnore
    @ApiModelProperty(value = "结束时间")
    private String signTimeLESS;


    @ExcelProperty(value = "打卡类型", index = 3)
    @ApiModelProperty(value = "打卡类型")
    private String type;

    @ExcelIgnore
    @ApiModelProperty(value = "当日驻站消防队总人数(可变)")
    private String personOfDay;

}
