package com.yeejoin.amos.boot.module.jcs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 警情填报类型枚举
 *
 * @author DELL
 */
@Getter
@AllArgsConstructor
public enum AlertBusinessTypeEnum {

    /**
     * 警情续报,非警情确认,警情结案
     */
    一般火灾警情初报("fireReportAlert", "229", "297", "SMS_JCS_0001", "一般火灾警情初报"),
    航空器救援警情初报("aircraftReportAlert", "230","297","SMS_JCS_0002", "航空器救援警情初报"),
    突发事件救援警情初报("emergenciesReportAlert", "235", "297","SMS_JCS_0003", "突发事件救援警情初报"),
    漏油现场安全保障警情初报("oilSpillReportAlert", "237", "297","SMS_JCS_0004", "漏油现场安全保障警情初报"),
    专机保障警情初报("specialReportAlert", "238", "297","SMS_JCS_0005", "专机保障警情初报"),
    警情初报("reportAlert", "297", "297","", "警情初报"),
    警情续报("followReportAlert", "313", "313","SMS_JCS_0006", "警情续报"),
    非警情确认("notAlert", "314", "314","SMS_JCS_0008", "非警情确认"),
    力量调派("powerTransfer", "316", "316","SMS_JCS_DP", "力量调派"),
    警情结案("endAlert", "315", "315","SMS_JCS_0009", "警情结案");

    private String key;
    private String code;
    private String parentCode;
    private String sms_code;
    private String name;
}
