package com.yeejoin.amos.boot.module.jcs.api.service;

import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.JcSituationDetail;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompanyResources;

import java.util.List;

/**
 * 调派单位资源 服务类
 *
 * @author tb
 * @date 2021-06-17
 */
public interface IPowerTransferCompanyResourcesService {


    AlertCalled getByPowerTransferCompanyResourId(Long id);


    PowerTransferCompanyResources getByAlertCalledIdCarId(Long alertCalledId, Long carId);

    void updateByAlertCalledId(Long alertCalledId);

    void updatePowerTransferCompanyResourcesService(Long alertCalledId, Long carId, String code, int type, String remarks, List<String> photos);


    List<JcSituationDetail> getTaskFeedback(Long carid, Long alertCalledId);

    /**
     * 根据ID获取资源信息
     *
     * @param resourceId 资源id
     * @return 车辆状态
     */
    PowerTransferCompanyResources getResourceById(String resourceId);

    /**
     * 根据ID获取资源数量   getResourceById修改
     * @param resourceId
     * @return
     */
    int getCarExecutingCountById(String resourceId, String status);
}
