package com.yeejoin.amos.boot.module.jcs.api.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.itextpdf.text.DocumentException;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 交接班记录表接口类
 *
 * @author system_generator
 * @date 2021-07-13
 */
public interface IShiftChangeService {

    /**
     * 模型创建
     *
     * @param model 信息
     * @return Map<String, Object>
     */
    Map<String, Object> createFormAndEntry(Map<String, Object> model);


    IPage<Map<String, Object>> queryForShiftChangePageByAid(int current, int size);
    /**
     * 删除完整信息
     *
     * @param sequenceNbr 主键
     * @return Boolean
     */
    Boolean removeOneById(Long sequenceNbr);

    /**
     * 交接班详情
     *
     * @param sequenceNbr 主键
     * @return Map<String, Object>
     */
    Map<String, Object> getOneBySeq(Long sequenceNbr);

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    页大小
     * @return IPage<Map < String, Object>>
     */
    IPage<Map<String, Object>> queryForShiftChangePage(int current, int size);

    /**
     * 查询全部值班记录
     *
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> queryForShiftChangeList();

    /**
     * 最近交班记录
     * @return Map<String, Object>
     */
    Map<String, Object> lastRecord();

    /**
     * 根据交接班记录id生成pdf
     */
    void exportPdfById(HttpServletResponse response, Long shiftChangeId) throws IOException, DocumentException;
}
