package com.yeejoin.precontrol.common.constant;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;

/**
 * @Description: 常量类
 * @Author: duanwei
 * @Date: 2019/7/29
 */
public interface Constant {
    String SMALL_PRO_PRCODE = "SMALL_PRO_PRCODE_";
    String SMALL_PRO_COMPANY_PRCODE = "SMALL_";
    String RESULT_SUCCESS = "SUCCESS";
    String RESULT_FAILURE = "FAILURE";
    /**
     * 任务-作业交底
     */
    Long JOB_TYPE = 0L;
    /**
     * 任务-三交三查
     */
    Long HAND_QUERY = 1L;
    /**
     * 违规管理
     */
    Long BAD_MANAGEMENT = 2L;
    Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    String FILE_SEPARATOR = System.getProperty("file.separator");
    DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    String PAGE_NUM = "0";
    String SIZE_NUM = "20";
    String PAGE = "page";
    String SIZE = "size";
    String ZERO = "0";
    String ONE = "1";
    String TWO = "2";
    String THREE = "3";
    String FOUR = "4";
    String FIVE = "5";
    String NULL = "";
    String JSON_NULL = "[]";
    /**
     * 请求成功
     */
    String SUCCESS = "200";
    /**
     * 请求错误
     */
    String ERROR = "300";
    /**
     * 无权限
     */
    String PERMISSION = "401";
    /**
     * 请求成功，其他错误
     */
    String DATA_NULL = "402";
    /**
     * 请求失败
     */
    String FAILED = "999";
    /**
     * 最大值
     */
    Integer MAX = 32767;
    /**
     * 数据请求返回码
     */
    public static final int RESCODE_SUCCESS = 1000;                //成功
    public static final int RESCODE_SUCCESS_MSG = 1001;            //成功(有返回信息)
    public static final int RESCODE_EXCEPTION = 1002;            //请求抛出异常
    public static final int RESCODE_NOLOGIN = 1003;                //未登陆状态
    public static final int RESCODE_NOEXIST = 1004;                //查询结果为空
    public static final int RESCODE_NOAUTH = 1005;                //无操作权限
    public static final int RESCODE_LOGINEXPIRE = 1006;                //登录过期
    /**
     * token
     */
    public static final int JWT_ERRCODE_EXPIRE = 1007;//Token过期
    public static final int JWT_ERRCODE_FAIL = 1008;//验证不通过
    /**
     * jwt
     */
    public static final String JWT_ID = "jwt-black";//jwt签发者
    public static final String JWT_SECRET = "Isi5Ob9OfvJt+4IHoMJlHkS1ttg=";//密匙
    public static final int JWT_TTL = 60 * 60 * 1000; // 60*60*1000;  //millisecond
    public static final int JWT_REFRESH_INTERVAL = 18 * 1000; //55*60*1000;  //millisecond
    public static final int JWT_REFRESH_TTL = 60 * 1000; // 12*60*60*1000;  //millisecond

    public static final String EXAM_TYPE = "EXAM_TYPE";//考试类型枚举

    /**
     * 在建项目状态组
     */
    public static final String[] BUILD_PROJECT_STATUS_GROUP = {"开发", "在建", "策划"};

    /**
     * 安全员角色key(role_key)
     */
    public static final String SECURITY = "security";
    /**
     * 技术员角色key(role_key)
     */
    public static final String TECHNICINA = "technician";

    /**
     * 危险作业
     */
    Long RISK_WORK = 3L;

    /**
     * 企业
     */
    public static final String COMPANY_LIST = "companyList_";
    /**
     * 企业下的子部门
     */
    public static final String COMPANY_CHILDRES_LIST = "companyChildrensList_";
    /**
     * 角色
     */
    public static final String ROLE_LIST = "roleList";

    /**
     * 违章类型
     */
    public static final String VIOLATION_NATURE = "violationNatureList";

    // websocket 推送 数据类型标志
    // 所有
    public static final String WS_ALL = "all";
    //1反违章统计
    public static final String WS_VIOLATIONSUM = "violationSum";
    //2综合统计
    public static final String WS_COMPOSITESUM = "compositeSum";
    //3违章排名
    public static final String WS_VIOLATIONRANK = "violationRank";
    //4分包商违章排名
    public static final String WS_FBSVIOLATIONRANK = "fbsViolationRank";
    //5风险作业
    public static final String WS_RISKSUM = "riskSum";
    //6红绿码
    public static final String WS_REDORGREENCODE = "redOrGreenCode";
    //7地图 项目点
    public static final String WS_MAPPROJECTSUM = "mapProjectSum";
    //风险管控屏幕  风险作业信息统计 进行中 已完成
    public static final String WS_RISKSTATUS = "riskStatus";
    //9违章管理 屏幕   今日违章
    public static final String WS_DAYVIOLATION = "dayViolation";
    public static final String WS_ZERO = "0";
}
