package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 技术文库Dto
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class DocumentDto  extends BaseDto implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    @ApiModelProperty(value = "人员id")
    private Long personId;
    @ApiModelProperty(value = "人员类型")
    private String personType;
    @ApiModelProperty(value = "文档ID")
    private Long documentId;
    @ApiModelProperty(value = "附件路径")
    @ImagePrefix
    private String filePath;
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "文档名称")
    private String name;
    @ApiModelProperty(value = "文档类型")
    private String type;
    @ApiModelProperty(value = "文档二维码")
    private String qrCode;
    @ApiModelProperty(value = "文档数量")
    private String number;

}
