package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.entity.TaskPerson;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @description: 知识分享
 * @author: wujiang
 * @date: 2020-07-17 15:48
 **/
@Data
public class KnowledgeShareDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "任务id")
	private Long id;
	@ApiModelProperty(value = "所属项目id")
	private Long projectId;
	@ApiModelProperty(value = "所属项目名称")
	private String projectName;
	@ApiModelProperty(value = "方案名称")
	private String name;
	@ApiModelProperty(value = "方案代号")
	private String code;
	@ApiModelProperty(value = "方案编号")
	private String number;
	@ApiModelProperty(value = "技术交底文件Id")
	private Long documentId;
	@ApiModelProperty(value = "技术交底文件名称")
	private String documentName;
	@ApiModelProperty(value = "发起人")
	private Long createPersonId;
	@ApiModelProperty(value = "参与学习人id")
	private List<Long> studyPersonIds;
	@ApiModelProperty(value = "参与学习人")
	private List<TaskPerson> studyPersonList;
	@ApiModelProperty(value = "参与学习人姓名")
	private List<String> studyPersonNames;
	@ApiModelProperty(value = "公司id")
	private Long companyId;
	@ApiModelProperty(value = "行业")
	private String industryType;
	@ApiModelProperty(value = "任务id")
	private Long taskId;

	@ApiModelProperty(value = "阅读状态（1：已读，0：未读）")
	private Long readStatus;
}
