package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 人员归属信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_person_ascription")
@ApiModel(value = "PersonAscription对象", description = "人员归属信息")
public class PersonAscription extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    private Long personId;
    @ApiModelProperty(value = "所在单位id")
    private Long companyId;
    @ApiModelProperty(value = "所在单位名称")
    @TableField(exist = false)
    private String companyName;
    @ApiModelProperty(value = "进入本单位工作时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date companyWorkTime;
    @ApiModelProperty(value = "所在项目id")
    private Long projectId;
    @ApiModelProperty(value = "所在项目名称")
    @TableField(exist = false)
    private String projectName;
    @ApiModelProperty(value = "部门/班组 id")
    private Long departmentId;
    @ApiModelProperty(value = "部门/班组名称")
    private String departmentName;
    @ApiModelProperty(value = "工作所在地key")
    private String workPlaceKey;
    @TableField(exist = false)
    private String workPlaceKeyLabel;
    @ApiModelProperty(value = "在场状态(0-在岗，1-不在岗)")
    private Integer status;
    @TableField(exist = false)
    private String statusLabel;
    @ApiModelProperty(value = "岗位名称")
    private String postName;
    @ApiModelProperty(value = "机构ID")
    private String orgCode;
    @ApiModelProperty(value = "岗位名称key")
    private String postNameKey;

}
