package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 项目安全态势评分表
 *
 * @author duanwei
 * @date 2020-08-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_score")
@ApiModel(value = "ProjectScore对象", description = "项目安全态势评分表")
public class ProjectScore extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目评分")
    private Long score;

    @ApiModelProperty(value = "项目id")
    private Long projectId;


}
