package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 任务人员知识库附件
 *
 * @author duanwei
 * @date 2022-03-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_person_knowledge_attachment")
@ApiModel(value="TaskPersonKnowledgeAttachment对象", description="任务人员知识库附件")
public class TaskPersonKnowledgeAttachment extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private Long taskId;
    
    private Long taskPersonId;

    private Long knowledgeId;

    private String name;

    @ImagePrefix
    private String url;

    private Integer readStatus;


}
