package com.yeejoin.precontrol.common.enums;

public enum MessageSalaryTypeEnum {
	
    NOT_RECEIVED(0, "未收到"),

    NOT_MATCH(1, "金额不符"),

    OTHER(2, "其他原因"),
    
    OVERTIME(3, "超时预警");

    private int type;

    private String name;

    MessageSalaryTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(int type) {
        String name = null;
        for (MessageSalaryTypeEnum enumOne : MessageSalaryTypeEnum.values()) {
            if (enumOne.getType() == type) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
