package com.yeejoin.precontrol.common.enums;

public enum TaskRiskStageEnum {

	UN_START("0", 0),

	SELECT_WORKER("1", 1),

	SELECT_EXAM_KNOWLEDGE("2", 2),

	DO_EXAM_AND_CHOOSE_SEC("3", 3),

	PHOTO("4", 4),

	EVALUATE("5", 5),
	
	COMPLETED("99", 99);

	private String label;
	private Integer value;

	TaskRiskStageEnum(String label, Integer value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public static String getLabelByValue(Integer value) {
		String label = null;
		for (SexEum type : SexEum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}

	public static TaskRiskStageEnum getEnumByValue(Integer value) {
		for (TaskRiskStageEnum enums : TaskRiskStageEnum.values()) {
			if (enums.getValue().equals(value)) {
				return enums;
			}
		}
		return null;
	}

	public static TaskRiskStageEnum next(Integer value) {
		if (value == TaskRiskStageEnum.EVALUATE.getValue() || value == TaskRiskStageEnum.COMPLETED.getValue()) {
			return TaskRiskStageEnum.COMPLETED;
		} else {
			return getEnumByValue(++value);
		}
	}

	public static TaskRiskStageEnum previous(Integer value) {
		if (value == TaskRiskStageEnum.COMPLETED.getValue()) {
			return TaskRiskStageEnum.EVALUATE;
		} else if (value == TaskRiskStageEnum.SELECT_WORKER.getValue()) {
			return TaskRiskStageEnum.SELECT_WORKER;
		} else {
			return getEnumByValue(--value);
		}
	}
}
