package com.yeejoin.precontrol.common.enums;

public enum TaskStatusEnum {

    /**
     * 未完成
     */
    UNCOMPLETED(0, "待办理"),
    /**
     * 已完成
     */
    COMPLETED(1, "已完成"),
    /**
     * 待审核
     */
    TOAUDIT(2, "待审核"),
    /**
     * 已退回
     */
    RETURNED(3, "已退回");

    private int type;

    private String name;

    TaskStatusEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }
    
    public long getLongType() {
        return Long.valueOf(type);
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(Long type) {
        String name = null;
        for (TaskStatusEnum enumOne : TaskStatusEnum.values()) {
            if (enumOne.getType() == type) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
