package com.yeejoin.precontrol.common.enums;

public enum TaskTimedTaskTypeEnum {

	   /**
     * 风险作业考试知识
     */
    RISK_EXAM_KNOWLEDGE(1, "风险作业考试知识");

    private int type;

    private String name;

    TaskTimedTaskTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }
    
    public long getLongType() {
        return Long.valueOf(type);
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(Long type) {
        String name = null;
        for (TaskTimedTaskTypeEnum enumOne : TaskTimedTaskTypeEnum.values()) {
            if (enumOne.getType() == type) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
