package com.yeejoin.precontrol.common.feign;

import com.alibaba.fastjson.JSON;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import javax.servlet.http.HttpServletRequest;

@Configuration
public class FeignRequestInterceptor implements RequestInterceptor {

	final static Logger log = LoggerFactory.getLogger(FeignRequestInterceptor.class);

	public FeignRequestInterceptor() {
	}

	@Override
	public void apply(RequestTemplate requestTemplate) {
		String appKey = null;
		String product = null;
		String token = null;
		HttpServletRequest request = null;
		if (RequestContextHolder.getRequestAttributes() != null) {
			request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
		}
		if (request != null) {
			appKey = request.getHeader("appKey");
			product = request.getHeader("product");
			token = request.getHeader("token");
		} else {
			appKey = RequestContext.getAppKey();
			product = RequestContext.getProduct();
			token = RequestContext.getToken();
		}
		log.info("FeignRequestInterceptor -------------" + JSON.toJSONString(appKey));
		log.info("FeignRequestInterceptor -------------" + JSON.toJSONString(product));
		log.info("FeignRequestInterceptor -------------" + JSON.toJSONString(token));
		requestTemplate.header("product", new String[] { product });
		requestTemplate.header("token", new String[] { token });
		requestTemplate.header("appKey", new String[] { appKey });
		// requestTemplate.header("appKey", new String[] { "studio_normalapp_2198572"
		// });
	}
}
