package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.PersonClock;
import com.yeejoin.precontrol.common.vo.PersonClockVo;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 人员履历信息(打卡) Mapper 接口
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface PersonClockMapper extends BaseMapper<PersonClock> {
	int pageInfoCount(HashMap<String, Object> param);

	List<PersonClockVo> pageInfo(@Param("param") HashMap<String, Object> param, Page<PersonClockVo> page);

	List<PersonClock> listEveryDayMinIn(@Param("param") Map<String, Object> param);

	List<PersonClock> listEveryDayMaxOut(@Param("param") Map<String, Object> param);

	IPage<PersonClockVo> listByDevice(Page<PersonClockVo> page, @Param("param") PersonClockVo personClockVo);
}
