package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.RewardExchange;
import com.yeejoin.precontrol.common.vo.RewardExchangeWechatVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 奖励兑换 mapper接口
 *
 * @author wbin
 * @date 2021-04-06
 */
public interface RewardExchangeMapper extends BaseMapper<RewardExchange> {

    /**
     * 选择日期的奖励兑换详情
     *
     * @param date
     * @param personId
     * @return
     */
    List<RewardExchangeWechatVo> selectByDate(@Param("date") String date, @Param("personId") Long personId);

    /**
     * 已兑换总金额
     *
     * @param personId
     * @return
     */
    String selectTotalMoney(@Param("personId") Long personId);

    /**
     * 查询在该日期区间的兑换记录
     *
     * @param startDate
     * @param endDate
     * @param personId
     * @return
     */
    List<RewardExchange> selectReportList(@Param("startDate") String startDate, @Param("endDate") String endDate, @Param("personId") Long personId);
    
    IPage<RewardExchangeWechatVo> exchangeRecord(Page<RewardExchangeWechatVo> page,@Param("personId") Long personId);
}
