package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.StatisticsDto;
import com.yeejoin.precontrol.common.vo.WorkActivityVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface StatisticsMapper {

	/**
	 * 风险作业数量(三交三查)
	 */
	int riskCount(StatisticsDto statisticsDto, boolean isToday, Long status, Long currentStatus);
	
	/**
	 * 风险作业数量
	 */
	int riskControlCount(StatisticsDto statisticsDto, boolean isToday, Long status, String statusKey);

	/**
	 * 作业活动数量
	 */
	int taskCount(StatisticsDto statisticsDto, boolean isToday, Long type, Long status, Long currentStatus);
	
	/**
	 * 作业票数量
	 */
	int ticketCount(StatisticsDto statisticsDto, boolean isToday,Long status, Long currentStatus);

	/**
	 * 项目人员数量
	 */
	int projectPersonCount(StatisticsDto statisticsDto, Long typeKey, List<String> status, Long color);

	/**
	 * 分包商人员数量(通过项目表)
	 */
	int companyPersonCount(StatisticsDto statisticsDto, Long typeKey, List<String> status, Long isBlack,
			Boolean isOnDuty);

	/**
	 * 分包商人员数量(通过人员表)
	 */
	int companyPersonCountByPerson(StatisticsDto statisticsDto, Long typeKey, List<String> status, Long isBlack);

	/**
	 * 风险作业项目数量
	 */
	int riskProjectCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 风险作业分包商数量
	 */
	int riskCompanyCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 风险作业项目数量
	 */
	int ticketProjectCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 风险作业分包商数量
	 */
	int ticketCompanyCount(StatisticsDto statisticsDto, boolean isToday);

	
	/**
	 * 违章数量
	 */
	int badCount(StatisticsDto statisticsDto, boolean isToday, String type);

	/**
	 * 违章项目数量
	 */
	int badProjectCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 违章分包商数量
	 */
	int badCompanyCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 技术交底人员数量（分包商的所有人）
	 */
	int techPersonCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 入场人员
	 */
	int inPersonCount(StatisticsDto statisticsDto, boolean isToday, String roleKey, boolean isNoTech);

	/**
	 * 交底项目数
	 */
	int techProjectCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 交底分包商数
	 */
	int techCompanyCount(StatisticsDto statisticsDto, boolean isToday);

	/**
	 * 入场项目数
	 */
	int inProjectCount(StatisticsDto statisticsDto, boolean isToday, boolean isNoTech);

	/**
	 * 入场分包商数
	 */
	int inCompanyCount(StatisticsDto statisticsDto, boolean isToday, boolean isNoTech);

	/**
	 * 项目数
	 */
	int projectCount(StatisticsDto statisticsDto, List<String> status);

	/**
	 * 分包商数
	 */
	int companyCount(StatisticsDto statisticsDto, boolean isOnDuty);

	/**
	 * 人员数
	 */
	int personCount(StatisticsDto statisticsDto, boolean isOnDuty, Long typeKey);

	/**
	 * 任务人员数
	 */
	int taskPersonCount(StatisticsDto statisticsDto, Long type);

	/**
	 * 风险作业
	 * @param sequenceNbr id
	 * @return Map
	 */
	Map<String, Object> countRiskWork(Long sequenceNbr);

	/**
	 * 违章考试
	 * @param sequenceNbr id
	 * @return Map
	 */
	Map<String, Object> countBadCheck(Long sequenceNbr);

	/**
	 * 通用查询
	 * @param personId id
	 * @param value 任务类型
	 * @return Map
	 */
	Map<String, Object> countTaskByTypeAndPersonAndStatus(@Param("personId") Long personId, @Param("type") Long value);

	/**
	 * 待办列表-查询风险作业统计
	 *
	 * @param orgCode
	 * @return
	 */
    Map<String, Object> riskWorkCount(String orgCode);

    IPage<WorkActivityVo> workActivityPageInfo(Page<WorkActivityVo> page,@Param("workActivityVo") WorkActivityVo workActivityVo);
}
