package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.entity.BadManagement;
import com.yeejoin.precontrol.common.vo.BadManagementVo;

import java.util.List;

/**
 * 服务类
 *
 * @author duanwei
 * @date 2020-07-06
 */
public interface IBadManagementService extends IService<BadManagement> {

    /**
     * 查询人员数量
     *
     * @param personId
     * @return
     */
    int selectCountByPersonId(Long personId);

    /**
     * 反违章统计
     *
     * @return
     */
    List<Object> violationSum(String orgCode, Long projectId);

    /**
     * 分包商违章列表
     *
     * @return
     */
    Page<BadManagementVo> pageList(Long current, Long size, String companyId);
}
