package com.yeejoin.precontrol.common.service;


import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;

import java.util.List;

/**
 * 通用查询方法
 * @author duanwei
 * @date 2020-06-30
 */
public interface IBaseService<S extends BaseEntity, R> {

    /**
     * 通用添加
     * @param obj1
     * @return
     */
    Boolean add(S obj1);
    /**
     * 通用删除
     * @param obj1
     * @param id
     * @return
     */
    Boolean remove(S obj1, Long id);
    /**
     * 通用删除 根据属性
     * @param obj1
     * @param key
     * @param value
     * @return
     */
    Boolean removeByField(S obj1, String key, Long value);

    /**
     * 通用删除 根据多个id
     * @param obj1
     * @param key
     * @param value
     * @return
     */
    Boolean removeByFields(S obj1, String key, List<Long> value);

    /**
     * 通用更新
     * @param obj1
     * @return
     */
    Boolean update(S obj1);

    /**
     * 通用查找 根据id
     * @param obj1
     * @param id
     * @return
     */
    Object findById(S obj1, Long id);

    /**
     * 通用查询
     * @param obj1
     * @return
     */
    List<Object> list(S obj1);
    /**
     * 通用查询 根据条件
     * @param obj1
     * @param queryWrapper
     * @return
     */
    List<Object> list(S obj1, Wrapper<S> queryWrapper);

    /**
     * 通用查询 根据多个参数
     * @param obj1
     * @param isQueryWrapper
     * @param param
     * @return
     */
    List<Object> list(S obj1, Boolean isQueryWrapper, String... param);

    /**
     * 通用查询 指定key value 根据多个参数
     * @param obj1
     * @param key
     * @param value
     * @param param
     * @return
     */
    List<Object> list(S obj1, String key, Long value, String... param);

    /**
     * 通用查询 指定key 多个value 根据多个参数
     * @param obj1
     * @param key
     * @param value
     * @param param
     * @return
     */
    List<Object> listByFields(S obj1, String key, List<Long> value, String... param);


}
