package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.CompanyBusinessAttachment;
import com.yeejoin.precontrol.common.mapper.CompanyBusinessAttachmentMapper;
import com.yeejoin.precontrol.common.service.ICompanyBusinessAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 企业工商附件信息 服务实现类
 *
 * @author sqy
 */
@Service
public class CompanyBusinessAttachmentServiceImpl extends ServiceImpl<CompanyBusinessAttachmentMapper, CompanyBusinessAttachment> implements ICompanyBusinessAttachmentService {
    @Autowired
    private CompanyBusinessAttachmentMapper businessAttachMapper;
    @Value("${fileserver.domain}")
    String fileServerUrl;

    @Override
    public void saveAttach(Long businessId, List<CompanyBusinessAttachment> attachment) {
        businessAttachMapper.delete(new QueryWrapper<CompanyBusinessAttachment>().lambda()
                .eq(CompanyBusinessAttachment::getCompanyBusinessId, businessId));
        if (attachment != null) {
            attachment.forEach(a -> {
                a.setCompanyBusinessId(businessId);
                a.setAttachment(a.getAttachment().replace(fileServerUrl, ""));
                businessAttachMapper.insert(a);
            });
        }
    }
}
