package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.HazardousWorkPageDto;
import com.yeejoin.precontrol.common.dto.InputItemDto;
import com.yeejoin.precontrol.common.entity.HazardousWork;
import com.yeejoin.precontrol.common.entity.HazardousWorkRefInputItem;
import com.yeejoin.precontrol.common.entity.InputItem;
import com.yeejoin.precontrol.common.mapper.HazardousWorkMapper;
import com.yeejoin.precontrol.common.service.IHazardousWorkRefInputItemService;
import com.yeejoin.precontrol.common.service.IHazardousWorkService;
import com.yeejoin.precontrol.common.service.IInputItemService;
import com.yeejoin.precontrol.common.utils.StringUtil;
import com.yeejoin.precontrol.common.vo.HazardousWorkPageVo;
import com.yeejoin.precontrol.common.vo.HazardousWorkVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 危险作业表 服务实现类
 *
 * @author duanwei
 * @date 2020-08-24
 */
@Service
public class HazardousWorkServiceImpl extends ServiceImpl<HazardousWorkMapper, HazardousWork>
		implements IHazardousWorkService {
	@Autowired
	IHazardousWorkService iHazardousWorkService;

	@Autowired
	IInputItemService iInputItemService;

	@Autowired
	IHazardousWorkRefInputItemService iHazardousWorkRefInputItemService;

	@Autowired
	HazardousWorkMapper hazardousWorkMapper;

	@Override
	public IPage<HazardousWorkPageVo> listByPage(CommonPageableDto pageable,
			HazardousWorkPageDto hazardousWorkPageDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<HazardousWorkPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<HazardousWorkPageVo> iPageData = hazardousWorkMapper.findByAll(page, hazardousWorkPageDto);
		return iPageData;
	}

	@Override
	public HazardousWorkVo getHazardousWorkVo(Long id) {
		HazardousWorkVo hazardousWorkVo = new HazardousWorkVo();
		HazardousWork hazardousWork = iHazardousWorkService.getById(id);
		if (hazardousWork == null) {
			return hazardousWorkVo;
		}
		BeanUtils.copyProperties(hazardousWork, hazardousWorkVo);
		List<HazardousWorkRefInputItem> hazardousWorkRefInputItemServices = iHazardousWorkRefInputItemService.list(
				new LambdaQueryWrapper<HazardousWorkRefInputItem>().select(HazardousWorkRefInputItem::getInputItemId)
						.eq(HazardousWorkRefInputItem::getHazardousWorkId, id));
		List<InputItemDto> inputItemDtos = new ArrayList<>();
		hazardousWorkVo.setInputItemDtos(inputItemDtos);
		if (StringUtil.isNotEmpty(hazardousWorkRefInputItemServices)) {
			List<Long> refIds = hazardousWorkRefInputItemServices.stream().map(l -> l.getInputItemId())
					.collect(Collectors.toList());
			Collection<InputItem> inputItems = iInputItemService.listByIds(refIds);
			if (StringUtil.isNotEmpty(inputItems)) {
				inputItems.forEach(inputItem -> {
					InputItemDto inputItemDto = new InputItemDto();
					BeanUtils.copyProperties(inputItem, inputItemDto);
					inputItemDto.setKey(inputItemDto.getId());
					hazardousWorkVo.getInputItemDtos().add(inputItemDto);
				});
			}
		}
		return hazardousWorkVo;
	}
}
