package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.ProjectHistroyDto;
import com.yeejoin.precontrol.common.entity.Districts;
import com.yeejoin.precontrol.common.entity.ProjectHistory;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.mapper.ProjectHistoryMapper;
import com.yeejoin.precontrol.common.service.IDistrictsService;
import com.yeejoin.precontrol.common.service.IProjectHistoryService;
import com.yeejoin.precontrol.common.vo.ProjectHistoryVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目历史轨迹 服务实现类
 *
 * @author duanwei
 * @date 2020-07-16
 */
@Service
@Slf4j
public class ProjectHistoryServiceImpl extends ServiceImpl<ProjectHistoryMapper, ProjectHistory> implements IProjectHistoryService {

    @Autowired
    ProjectHistoryMapper projectHistoryMapper;

    @Autowired
    IDistrictsService iDistrictsService;


    @Override
    public IPage<ProjectHistoryVo> listByPage(CommonPageableDto pageable, ProjectHistroyDto projectHistroyDto) {
        if (pageable.getIsAll() == 1) {
            pageable.setPageNumber(0);
            pageable.setPageSize(Integer.MAX_VALUE);
        } else {
            Integer pageNumber = pageable.getPageNumber();
            Integer pageSize = pageable.getPageSize();
            if (null == pageNumber || null == pageSize) {
                throw new BaseException("isAll为0时,分页参数必须传递");
            }
        }
        Page<ProjectHistoryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        IPage<ProjectHistoryVo> iPageData = projectHistoryMapper.findByAll(page, projectHistroyDto);
        List<ProjectHistoryVo> projectHistoryVos = iPageData.getRecords();
        if (null != projectHistoryVos && projectHistoryVos.size() > 0) {
            projectHistoryVos.forEach(projectHistoryVo -> {
                Date startTime = projectHistoryVo.getStartTime();
                Date endTime = projectHistoryVo.getEndTime();
                if (endTime == null) {
                    Date date = new Date();
                    Integer day = getDayDiff(startTime, date);
                    int age = day / 365;
                    if (age == 0) {
                        projectHistoryVo.setAge("小于1年");
                    } else {
                        projectHistoryVo.setAge(String.valueOf(age));
                    }
                } else {
                    Integer day = getDayDiff(startTime, endTime);
                    int age = day / 365;
                    if (age == 0) {
                        projectHistoryVo.setAge("小于1年");
                    } else {
                        projectHistoryVo.setAge(String.valueOf(age));
                    }
                }


                //转换地区
                if (StringUtils.isNotBlank(projectHistoryVo.getRegion())) {
                    String[] split = projectHistoryVo.getRegion().split(",");
                    LinkedList<Long> collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toCollection(LinkedList::new));
                    Collection<Districts> districts = iDistrictsService.listByIds(collect);
                    StringBuffer districtsName = new StringBuffer();
                    districts.forEach(districts1 -> districtsName.append(districts1.getExtName()).append(","));
                    districtsName.deleteCharAt(districtsName.length() - 1);
                    projectHistoryVo.setRegionName(districtsName.toString());
                }
            });
        }
        return iPageData;
    }


    public static Integer getDayDiff(Date smdate, Date bdate) {
        long betweenDays = 0L;
        try {
            betweenDays = (bdate.getTime() - smdate.getTime()) / (1000 * 3600 * 24);
        } catch (Exception e) {
            log.error("日期转换错误");
        }
        return Integer.parseInt(String.valueOf(betweenDays));
    }
}
